/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.util.LinkedHashSet;
import java.util.Set;
import net.fichotheque.exportation.table.TableExportDef;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.misc.DefBuilder;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.StringUtils;

public class TableExportDefBuilder
extends DefBuilder {
    private final String name;
    private String langMode;
    private final Set<Lang> langSet = new LinkedHashSet<Lang>();

    public TableExportDefBuilder(String name) {
        this(name, null);
    }

    public TableExportDefBuilder(String name, @Nullable Attributes initAttributes) {
        super(initAttributes);
        if (!StringUtils.isTechnicalName(name, true)) {
            throw new IllegalArgumentException("Wrong syntax");
        }
        this.name = name;
    }

    public TableExportDefBuilder setLangMode(@Nullable String langMode) {
        this.langMode = langMode;
        return this;
    }

    public TableExportDefBuilder addLang(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("lang is null");
        }
        this.langSet.add(lang);
        return this;
    }

    public TableExportDef toTableExportDef() {
        Langs langs = this.langSet.size() > 0 ? LangsUtils.fromCollection(this.langSet) : LangsUtils.EMPTY_LANGS;
        Labels titleLabels = this.toLabels();
        Attributes attributes = this.toAttributes();
        return new InternalTableExportDef(this.name, this.langMode, langs, titleLabels, attributes);
    }

    public static TableExportDefBuilder init(String name, @Nullable Attributes initAttributes) {
        return new TableExportDefBuilder(name, initAttributes);
    }

    private static class InternalTableExportDef
    implements TableExportDef {
        private final String name;
        private final String langMode;
        private final Langs langs;
        private final Labels titleLabels;
        private final Attributes attributes;

        private InternalTableExportDef(String name, String langMode, Langs langs, Labels titleLabels, Attributes attributes) {
            this.name = name;
            this.langMode = langMode;
            this.langs = langs;
            this.titleLabels = titleLabels;
            this.attributes = attributes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Labels getTitleLabels() {
            return this.titleLabels;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public String getLangMode() {
            return this.langMode;
        }

        @Override
        public Langs getLangs() {
            return this.langs;
        }
    }
}

