/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.table.JunctionTableExportInfo;

public class JunctionParser {
    private Result result = new Result();
    private String currentTableNameLine = null;
    private String currentSubsetKey1Line = null;
    private String currentSubsetKey2Line = null;
    private int currentLineNumber;
    private int firstLineNumber;

    public static Result parse(Reader reader) throws IOException {
        JunctionParser parser = new JunctionParser();
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        String line = null;
        while ((line = lineNumberReader.readLine()) != null) {
            int lineNumber = lineNumberReader.getLineNumber();
            if ((line = line.trim()).length() == 0) {
                parser.flush();
                continue;
            }
            if (line.startsWith("#")) continue;
            parser.addLine(line, lineNumber);
        }
        parser.flush();
        return parser.result;
    }

    private void flush() {
        if (this.currentTableNameLine != null) {
            if (this.currentSubsetKey1Line == null) {
                this.clear();
                return;
            }
            if (this.currentSubsetKey2Line == null) {
                this.clear();
                return;
            }
            SubsetKey subsetKey1 = null;
            SubsetKey subsetKey2 = null;
            try {
                subsetKey1 = SubsetKey.parse(this.currentSubsetKey1Line);
            }
            catch (ParseException pe) {
                this.clear();
                return;
            }
            try {
                subsetKey2 = SubsetKey.parse(this.currentSubsetKey2Line);
            }
            catch (ParseException pe) {
                this.clear();
                return;
            }
            this.result.add(this.currentTableNameLine, subsetKey1, subsetKey2);
            this.clear();
        }
    }

    private void addLine(String line, int currentLineNumber) {
        this.currentLineNumber = currentLineNumber;
        if (this.currentTableNameLine == null) {
            this.currentTableNameLine = line;
            this.firstLineNumber = currentLineNumber;
        } else if (this.currentSubsetKey1Line == null) {
            this.currentSubsetKey1Line = line;
        } else if (this.currentSubsetKey2Line == null) {
            this.currentSubsetKey2Line = line;
        }
    }

    private void clear() {
        this.currentTableNameLine = null;
        this.currentSubsetKey1Line = null;
        this.currentSubsetKey2Line = null;
    }

    public static class Result {
        List<JunctionTableExportInfo> junctionTableExportInfoList = new ArrayList<JunctionTableExportInfo>();

        void add(String name, SubsetKey subsetKey1, SubsetKey subsetKey2) {
            this.junctionTableExportInfoList.add(new InternalJunctionTableExportInfo(name, subsetKey1, subsetKey2));
        }

        public List<JunctionTableExportInfo> getJunctionTableExportInfoList() {
            return this.junctionTableExportInfoList;
        }
    }

    private static class InternalJunctionTableExportInfo
    implements JunctionTableExportInfo {
        String tableName;
        SubsetKey subsetKey1;
        SubsetKey subsetKey2;

        InternalJunctionTableExportInfo(String name, SubsetKey subsetKey1, SubsetKey subsetKey2) {
            this.tableName = name;
            this.subsetKey1 = subsetKey1;
            this.subsetKey2 = subsetKey2;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public SubsetKey getSubsetKey1() {
            return this.subsetKey1;
        }

        @Override
        public SubsetKey getSubsetKey2() {
            return this.subsetKey2;
        }
    }
}

