/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.scrutari;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.scrutari.ThesaurusScrutariDef;
import net.mapeadores.util.text.StringUtils;

public class ThesaurusScrutariDefBuilder {
    private final SubsetKey thesaurusKey;
    private final Set<String> includeTokenSet = new LinkedHashSet<String>();
    private String fieldGenerationSource = "";
    private boolean wholeThesaurus = false;

    public ThesaurusScrutariDefBuilder(SubsetKey thesaurusKey) {
        this.thesaurusKey = thesaurusKey;
    }

    public ThesaurusScrutariDefBuilder setFieldGenerationSource(String source) {
        if (source == null) {
            source = "";
        }
        this.fieldGenerationSource = source;
        return this;
    }

    public ThesaurusScrutariDefBuilder setWholeThesaurus(boolean wholeThesaurus) {
        this.wholeThesaurus = wholeThesaurus;
        return this;
    }

    public ThesaurusScrutariDefBuilder addIncludeToken(String includeToken) {
        if (includeToken != null && includeToken.length() > 0) {
            this.includeTokenSet.add(includeToken);
        }
        return this;
    }

    public ThesaurusScrutariDefBuilder parseIncludeTokens(String includeTokens) {
        if (includeTokens != null) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTechnicalTokens(includeTokens, true)) {
                this.includeTokenSet.add(token);
            }
        }
        return this;
    }

    public ThesaurusScrutariDef toThesaurusScrutariDef() {
        List<String> attributeFilterList = StringUtils.toList(this.includeTokenSet);
        return new InternalThesaurusScrutariDef(this.thesaurusKey, this.fieldGenerationSource, this.wholeThesaurus, attributeFilterList);
    }

    public static ThesaurusScrutariDefBuilder init(SubsetKey thesaurusKey) {
        return new ThesaurusScrutariDefBuilder(thesaurusKey);
    }

    private static class InternalThesaurusScrutariDef
    implements ThesaurusScrutariDef {
        private final SubsetKey thesaurusKey;
        private final String fieldGenerationSource;
        private final boolean wholeThesaurus;
        private final List<String> includeTokenList;

        public InternalThesaurusScrutariDef(SubsetKey thesaurusKey, String fieldGenerationSource, boolean wholeThesaurus, List<String> includeTokenList) {
            this.thesaurusKey = thesaurusKey;
            this.fieldGenerationSource = fieldGenerationSource;
            this.wholeThesaurus = wholeThesaurus;
            this.includeTokenList = includeTokenList;
        }

        @Override
        public SubsetKey getThesaurusKey() {
            return this.thesaurusKey;
        }

        @Override
        public String getFieldGenerationSource() {
            return this.fieldGenerationSource;
        }

        @Override
        public boolean isWholeThesaurus() {
            return this.wholeThesaurus;
        }

        @Override
        public List<String> getIncludeTokenList() {
            return this.includeTokenList;
        }
    }
}

