/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.access;

import net.fichotheque.exportation.access.AccessDef;
import net.fichotheque.selection.SelectionOptions;
import net.fichotheque.tools.selection.SelectionOptionsBuilder;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.misc.DefBuilder;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.StringUtils;

public class AccessDefBuilder
extends DefBuilder {
    private final String name;
    private final SelectionOptionsBuilder selectionOptionsBuilder = new SelectionOptionsBuilder();
    private String tableExportName = "";
    private String type = "private";
    private String token = "";

    public AccessDefBuilder(String name) {
        this(name, null);
    }

    public AccessDefBuilder(String name, Attributes initAttributes) {
        super(initAttributes);
        if (!StringUtils.isTechnicalName(name, true)) {
            throw new IllegalArgumentException("Wrong syntax");
        }
        this.name = name;
    }

    public SelectionOptionsBuilder getSelectionOptionsBuilder() {
        return this.selectionOptionsBuilder;
    }

    public AccessDefBuilder setType(String type) {
        try {
            this.type = AccessDef.checkType(type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    public AccessDefBuilder setToken(String token) {
        this.token = StringUtils.nullTrim(token);
        return this;
    }

    public AccessDefBuilder setTableExportName(String tableExportName) {
        this.tableExportName = StringUtils.nullTrim(tableExportName);
        return this;
    }

    public AccessDef toAccessDef() {
        Labels titleLabels = this.toLabels();
        Attributes attributes = this.toAttributes();
        return new InternalAccessDef(this.name, this.type, this.token, this.tableExportName, this.selectionOptionsBuilder.toSelectionOptions(), titleLabels, attributes);
    }

    public static AccessDefBuilder init(String name) {
        return new AccessDefBuilder(name);
    }

    public static AccessDefBuilder init(String name, Attributes initAttributes) {
        return new AccessDefBuilder(name, initAttributes);
    }

    private static class InternalAccessDef
    implements AccessDef {
        private final String name;
        private final String type;
        private final String token;
        private final String tableExportName;
        private final SelectionOptions selectionOptions;
        private final Labels titleLabels;
        private final Attributes attributes;

        private InternalAccessDef(String name, String type, String token, String tableExportName, SelectionOptions selectionOptions, Labels titleLabels, Attributes attributes) {
            this.name = name;
            this.type = type;
            this.token = token;
            this.tableExportName = tableExportName;
            this.selectionOptions = selectionOptions;
            this.titleLabels = titleLabels;
            this.attributes = attributes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Labels getTitleLabels() {
            return this.titleLabels;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getToken() {
            return this.token;
        }

        @Override
        public String getTableExportName() {
            return this.tableExportName;
        }

        @Override
        public SelectionOptions getSelectionOptions() {
            return this.selectionOptions;
        }
    }
}

