/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.MetadataEditor;
import net.fichotheque.namespaces.ExtractionSpace;
import net.fichotheque.tools.dom.FichothequeDOMUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public abstract class AbstractMetadataDOMReader {
    protected final MetadataEditor metadataEditor;
    protected final MessageHandler messageHandler;
    private final String oldIntituleName;

    public AbstractMetadataDOMReader(MetadataEditor metadataEditor, MessageHandler messageHandler) {
        this.metadataEditor = metadataEditor;
        this.messageHandler = messageHandler;
        this.oldIntituleName = "";
    }

    public AbstractMetadataDOMReader(MetadataEditor metadataEditor, MessageHandler messageHandler, String oldIntituleName) {
        this.metadataEditor = metadataEditor;
        this.messageHandler = messageHandler;
        this.oldIntituleName = oldIntituleName;
    }

    protected boolean readCommonElement(Element element, AttributesBuilder attributesBuilder, String parentXpath) {
        String tagName = element.getTagName();
        String xpath = parentXpath + "/" + tagName;
        boolean common = true;
        if (tagName.equals("label")) {
            try {
                Label label = LabelUtils.readLabel(element);
                if (label != null) {
                    this.metadataEditor.putTitle(label);
                }
            }
            catch (ParseException pe) {
                DomMessages.wrongLangAttribute(this.messageHandler, xpath, element.getAttribute("xml:lang"));
            }
        } else if (tagName.equals("phrase")) {
            String name = element.getAttribute("name");
            if (name.length() == 0) {
                DomMessages.emptyAttribute(this.messageHandler, xpath, "name");
            } else {
                xpath = xpath + "[@name='" + name + "']";
                DOMUtils.readChildren(element, new PhraseLabelConsumer(name, xpath));
            }
        } else if (tagName.equals("attr")) {
            AttributeUtils.readAttrElement(attributesBuilder, element, this.messageHandler, xpath, ExtractionSpace.EXTRACTION_ALIAS);
        } else if (tagName.equals("intitule")) {
            FichothequeDOMUtils.readIntitule(element, this.metadataEditor, this.messageHandler, this.oldIntituleName);
        } else {
            common = false;
        }
        return common;
    }

    protected void flush(AttributesBuilder attributesBuilder) {
        Attributes attributes = attributesBuilder.toAttributes();
        for (Attribute attribute : attributes) {
            this.metadataEditor.putAttribute(attribute);
        }
    }

    private class PhraseLabelConsumer
    implements Consumer<Element> {
        private final String phraseName;
        private final String parentXpath;

        PhraseLabelConsumer(String phraseName, String parentXpath) {
            this.phraseName = phraseName;
            this.parentXpath = parentXpath;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            String xpath = this.parentXpath + "/" + tagName;
            if (tagName.equals("label")) {
                try {
                    Label label = LabelUtils.readLabel(element);
                    if (label != null) {
                        AbstractMetadataDOMReader.this.metadataEditor.putLabel(this.phraseName, label);
                    }
                }
                catch (ParseException pe) {
                    DomMessages.wrongLangAttribute(AbstractMetadataDOMReader.this.messageHandler, xpath, element.getAttribute("xml:lang"));
                }
            } else {
                DomMessages.unknownTagWarning(AbstractMetadataDOMReader.this.messageHandler, xpath);
            }
        }
    }
}

