/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.fieldtofield;

import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.logging.MultiMessageHandler;

class PropToFicheItemField
extends FieldToFieldConverter {
    private final FieldKey sourceKey;
    private final FieldKey destinationKey;

    PropToFicheItemField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.sourceKey = sourceKey;
        this.destinationKey = destinationKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        Prop source = fiche.getProp(this.sourceKey);
        if (source != null) {
            FicheItem ficheItem = source.getFicheItem();
            if (this.destinationKey.isProp()) {
                fiche.setProp(this.destinationKey, ficheItem);
            } else {
                fiche.appendInfo(this.destinationKey, FicheUtils.toFicheItems(ficheItem));
            }
            if (removeOldField) {
                fiche.setProp(this.sourceKey, null);
            }
        }
    }
}

