/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Metadata;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.album.metadata.AlbumMetadataEditor;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.impl.AbstractSubsetItem;
import net.fichotheque.impl.AlbumDataSource;
import net.fichotheque.impl.AlbumMetadataImpl;
import net.fichotheque.impl.FichothequeImpl;
import net.fichotheque.utils.AlbumUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.images.ImagesUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;

class AlbumImpl
implements Album {
    private final SubsetKey albumKey;
    private final FichothequeImpl fichotheque;
    private final Map<Integer, IllustrationImpl> itemMap = new HashMap<Integer, IllustrationImpl>();
    private AlbumMetadataImpl albumMetadata;
    private int availableId = 1;
    private List<SubsetItem> cacheSubsetItemList;
    private List<Illustration> cacheList;

    private AlbumImpl(SubsetKey albumKey, FichothequeImpl fichotheque) {
        this.fichotheque = fichotheque;
        this.albumKey = albumKey;
    }

    static InitEditor fromInit(SubsetKey albumKey, FichothequeImpl fichotheque, FichothequeImpl.InitEditor fichothequeInitEditor) {
        AlbumImpl album = new AlbumImpl(albumKey, fichotheque);
        return new InitEditor(album, fichothequeInitEditor);
    }

    static AlbumImpl fromNew(SubsetKey albumKey, FichothequeImpl fichotheque) {
        AlbumImpl album = new AlbumImpl(albumKey, fichotheque);
        album.albumMetadata = AlbumMetadataImpl.fromNew(album);
        return album;
    }

    @Override
    public Fichotheque getFichotheque() {
        return this.fichotheque;
    }

    @Override
    public Metadata getMetadata() {
        return this.albumMetadata;
    }

    @Override
    public List<Illustration> getIllustrationList() {
        List<Illustration> result = this.cacheList;
        if (result == null) {
            result = this.initIllustrationList();
        }
        return result;
    }

    @Override
    public Illustration getIllustrationById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public SubsetKey getSubsetKey() {
        return this.albumKey;
    }

    @Override
    public SubsetItem getSubsetItemById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public List<SubsetItem> getSubsetItemList() {
        List<SubsetItem> list = this.cacheSubsetItemList;
        if (list == null) {
            list = this.initSubsetItemList();
        }
        return list;
    }

    @Override
    public int size() {
        return this.itemMap.size();
    }

    @Override
    public List<Corpus> getSatelliteCorpusList() {
        return FichothequeUtils.EMPTY_CORPUSLIST;
    }

    AlbumEditorImpl getAlbumEditor(FichothequeEditor fichothequeEditor) {
        return new AlbumEditorImpl(fichothequeEditor);
    }

    void clear() {
        this.albumMetadata.clear();
    }

    private synchronized Illustration innerCreateIllustration(int id, String type) throws ExistingIdException {
        if (id < 1) {
            id = this.availableId;
        } else if (this.itemMap.containsKey(id)) {
            throw new ExistingIdException();
        }
        IllustrationImpl implIllustration = new IllustrationImpl(id, type);
        this.itemMap.put(id, implIllustration);
        this.availableId = Math.max(this.availableId, id + 1);
        this.clearCache();
        return implIllustration;
    }

    private void innerUpdateIllustration(Illustration illustration, InputStream inputStream, String type) throws IOException, ErrorMessageException {
        IllustrationImpl implIllustration = (IllustrationImpl)illustration;
        implIllustration.type = type;
        byte[] byteArray = IOUtils.toByteArray(inputStream);
        BufferedImage bufferedImage = ImagesUtils.read(new ByteArrayInputStream(byteArray));
        implIllustration.originalWidth = bufferedImage.getWidth();
        implIllustration.originalHeight = bufferedImage.getHeight();
        this.getAlbumDataSource().update(illustration, new ByteArrayInputStream(byteArray));
    }

    private synchronized boolean innerRemoveIllustration(Illustration illustration) {
        IllustrationImpl implIllustration = (IllustrationImpl)illustration;
        if (!this.fichotheque.isRemoveable(implIllustration)) {
            return false;
        }
        int id = illustration.getId();
        this.itemMap.remove(id);
        this.clearCache();
        return true;
    }

    private void clearCache() {
        this.cacheSubsetItemList = null;
        this.cacheList = null;
    }

    private synchronized List<SubsetItem> initSubsetItemList() {
        TreeMap<Integer, IllustrationImpl> sortedMap = new TreeMap<Integer, IllustrationImpl>();
        sortedMap.putAll(this.itemMap);
        List<SubsetItem> list = FichothequeUtils.wrap(sortedMap.values().toArray(new SubsetItem[sortedMap.size()]));
        this.cacheSubsetItemList = list;
        return list;
    }

    private synchronized List<Illustration> initIllustrationList() {
        TreeMap<Integer, IllustrationImpl> sortedMap = new TreeMap<Integer, IllustrationImpl>();
        sortedMap.putAll(this.itemMap);
        List<Illustration> list = AlbumUtils.wrap(sortedMap.values().toArray(new Illustration[sortedMap.size()]));
        this.cacheList = list;
        return list;
    }

    private AlbumDataSource getAlbumDataSource() {
        return this.fichotheque.getFichothequeDataSource().getAlbumDataSource();
    }

    static class InitEditor
    implements AlbumEditor {
        private final AlbumImpl album;
        private final FichothequeImpl.InitEditor fichothequeInitEditor;
        private final AlbumMetadataImpl.InitEditor metadataInitEditor;

        private InitEditor(AlbumImpl album, FichothequeImpl.InitEditor fichothequeInitEditor) {
            this.album = album;
            this.fichothequeInitEditor = fichothequeInitEditor;
            this.metadataInitEditor = AlbumMetadataImpl.fromInit(this);
            album.albumMetadata = (AlbumMetadataImpl)this.metadataInitEditor.getMetadata();
        }

        @Override
        public Album getAlbum() {
            return this.album;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeInitEditor;
        }

        @Override
        public AlbumMetadataEditor getAlbumMetadataEditor() {
            return this.metadataInitEditor;
        }

        @Override
        public Illustration createIllustration(int id, String type) throws ExistingIdException {
            return this.album.innerCreateIllustration(id, type);
        }

        @Override
        public void updateIllustration(Illustration illustration, InputStream inputStream, String type) throws IOException, ErrorMessageException {
            IllustrationImpl implIllustration = (IllustrationImpl)illustration;
            BufferedImage bufferedImage = ImagesUtils.read(inputStream);
            implIllustration.originalWidth = bufferedImage.getWidth();
            implIllustration.originalHeight = bufferedImage.getHeight();
        }

        @Override
        public boolean removeIllustration(Illustration illustration) {
            throw new UnsupportedOperationException("Not during init");
        }
    }

    class AlbumEditorImpl
    implements AlbumEditor {
        private final FichothequeEditor fichothequeEditor;
        private final Set<Integer> changedIllustrationSet = new HashSet<Integer>();
        private final Set<Integer> removedIllustrationSet = new HashSet<Integer>();
        private AlbumMetadataEditor albumMetadataEditor;
        private boolean metadataChanged = false;

        private AlbumEditorImpl(FichothequeEditor fichothequeEditor) {
            this.fichothequeEditor = fichothequeEditor;
        }

        @Override
        public Album getAlbum() {
            return AlbumImpl.this;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeEditor;
        }

        @Override
        public AlbumMetadataEditor getAlbumMetadataEditor() {
            if (this.albumMetadataEditor == null) {
                this.albumMetadataEditor = AlbumImpl.this.albumMetadata.getAlbumMetadataEditor(this);
            }
            return this.albumMetadataEditor;
        }

        @Override
        public Illustration createIllustration(int id, String type) throws ExistingIdException {
            return AlbumImpl.this.innerCreateIllustration(id, type);
        }

        @Override
        public void updateIllustration(Illustration illustration, InputStream inputStream, String type) throws IOException, ErrorMessageException {
            AlbumImpl.this.innerUpdateIllustration(illustration, inputStream, type);
        }

        @Override
        public boolean removeIllustration(Illustration illustration) {
            int illustrationid = illustration.getId();
            boolean done = AlbumImpl.this.innerRemoveIllustration(illustration);
            if (done) {
                this.removedIllustrationSet.add(illustrationid);
            }
            return done;
        }

        void addIllustrationChange(int id) {
            this.changedIllustrationSet.add(id);
        }

        void setMetadataChange() {
            this.metadataChanged = true;
        }

        void saveChanges() {
            EditOrigin editOrigin = this.fichothequeEditor.getEditOrigin();
            AlbumDataSource albumDataSource = AlbumImpl.this.getAlbumDataSource();
            if (this.metadataChanged) {
                albumDataSource.saveMetadata(AlbumImpl.this, editOrigin);
                this.metadataChanged = false;
            }
            for (Integer id : this.changedIllustrationSet) {
                Illustration illustration = AlbumImpl.this.getIllustrationById(id);
                if (illustration == null) continue;
                albumDataSource.saveIllustration(illustration, editOrigin);
            }
            this.changedIllustrationSet.clear();
            for (Integer id : this.removedIllustrationSet) {
                albumDataSource.removeIllustration(AlbumImpl.this, id, editOrigin);
            }
            this.removedIllustrationSet.clear();
        }
    }

    private class IllustrationImpl
    extends AbstractSubsetItem
    implements Illustration {
        private final int id;
        private String type;
        private int originalWidth;
        private int originalHeight;

        private IllustrationImpl(int id, String type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public Subset getSubset() {
            return AlbumImpl.this;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getFormatType() {
            return this.type;
        }

        @Override
        public int getOriginalWidth() {
            return this.originalWidth;
        }

        @Override
        public int getOriginalHeight() {
            return this.originalHeight;
        }

        @Override
        public InputStream getInputStream(String specialDim) {
            switch (specialDim) {
                case "_original": {
                    return AlbumImpl.this.getAlbumDataSource().getInputStream(this, null, null);
                }
                case "_mini": {
                    return AlbumImpl.this.getAlbumDataSource().getInputStream(this, "_mini", AlbumImpl.this.albumMetadata.getResizeInfo(specialDim));
                }
            }
            throw new IllegalArgumentException("Unknown specialDim: " + specialDim);
        }

        @Override
        public InputStream getInputStream(AlbumDim albumDim) {
            if (!AlbumImpl.this.albumMetadata.isFromAlbum(albumDim)) {
                throw new IllegalArgumentException("albumDim is not linked to this Album");
            }
            return AlbumImpl.this.getAlbumDataSource().getInputStream(this, albumDim.getName(), albumDim.getResizeInfo());
        }
    }
}

