/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.List;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.Subset;
import net.fichotheque.impl.AbstractSubsetItem;
import net.fichotheque.impl.MotcleIconImpl;
import net.fichotheque.impl.Motcles;
import net.fichotheque.impl.ThesaurusImpl;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.MotcleIcon;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;

abstract class AbstractMotcle
extends AbstractSubsetItem
implements Motcle {
    private final ThesaurusImpl thesaurus;
    private final int id;
    private String idalpha;
    private int level = 1;
    private AbstractMotcle parent;
    private int childIndex;
    private Motcles motcles;
    private String status = "active";
    private MotcleIcon motcleIcon;
    private boolean motcleInit = false;

    public AbstractMotcle(ThesaurusImpl thesaurus, int id) {
        this.thesaurus = thesaurus;
        this.id = id;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public Motcle getParent() {
        return this.parent;
    }

    @Override
    public MotcleIcon getMotcleIcon() {
        if (this.motcleInit) {
            return this.motcleIcon;
        }
        this.motcleIcon = MotcleIconImpl.build(this.getAttributes());
        this.motcleInit = true;
        return this.motcleIcon;
    }

    @Override
    public Subset getSubset() {
        return this.thesaurus;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getIdalpha() {
        return this.idalpha;
    }

    @Override
    public int getChildIndex() {
        return this.childIndex;
    }

    @Override
    public List<Motcle> getChildList() {
        if (this.motcles == null) {
            return ThesaurusUtils.EMPTY_MOTCLELIST;
        }
        return this.motcles.getCache();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    abstract boolean putLabel(Label var1);

    abstract boolean removeLabel(Lang var1);

    @Override
    void fireAttributeChange() {
        this.motcleIcon = null;
        this.motcleInit = false;
    }

    boolean setIdalpha(String newIdalpha) {
        if (this.idalpha == null) {
            this.idalpha = newIdalpha;
            return true;
        }
        if (newIdalpha.equals(this.idalpha)) {
            return false;
        }
        this.idalpha = newIdalpha;
        return true;
    }

    boolean setParent(AbstractMotcle newParent) {
        boolean todo = this.parentTest(newParent);
        if (!todo) {
            return false;
        }
        this.removeFromParent();
        if (newParent != null) {
            this.level = newParent.getLevel() + 1;
            newParent.addChild(this);
        } else {
            this.level = 1;
            this.thesaurus.addInFirstLevel(this);
        }
        this.parent = newParent;
        return true;
    }

    boolean setStatus(String newStatus) {
        if (newStatus.equals(this.status)) {
            return false;
        }
        this.status = FichothequeConstants.checkMotcleStatus(newStatus);
        return true;
    }

    void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this.childIndex);
        } else {
            this.thesaurus.removeFromFirstLevel(this.childIndex);
        }
        this.childIndex = -1;
        this.level = -1;
    }

    private void removeChild(int index) {
        if (this.motcles != null) {
            this.motcles.remove(index);
        }
    }

    private void addChild(AbstractMotcle motcle) {
        if (this.motcles == null) {
            this.motcles = new Motcles();
        }
        this.motcles.add(motcle);
    }

    void decreaseIndex() {
        --this.childIndex;
    }

    void increaseIndex() {
        ++this.childIndex;
    }

    void setChildIndex(int childIndex) {
        this.childIndex = childIndex;
    }

    boolean changeIndex(int newIndex) {
        if (newIndex == this.childIndex) {
            return false;
        }
        Motcles list = this.parent != null ? this.parent.motcles : this.thesaurus.getFirstLevelMotcleList();
        list.permute(this.childIndex, newIndex);
        this.childIndex = newIndex;
        return true;
    }

    boolean parentTest(AbstractMotcle newParent) {
        if (newParent == null) {
            return this.parent != null;
        }
        if (this.parent == null) {
            return true;
        }
        return !this.parent.equals(newParent);
    }
}

