/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.history;

import java.util.Collections;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.history.FicheHistory;
import net.fichotheque.history.HistoryUnit;
import net.fichotheque.history.JunctionHistory;
import net.fichotheque.junction.JunctionKey;

public final class HistoryUtils {
    public static final List<FicheHistory> EMPTY_FICHEHISTORYLIST = Collections.emptyList();
    public static final List<JunctionHistory> EMPTY_JUNCTIONHISTORYLIST = Collections.emptyList();

    private HistoryUtils() {
    }

    public static FicheHistory toFicheHistory(SubsetKey corpusKey, int id, HistoryUnit ficheUnit, HistoryUnit attributesUnit) {
        return new InternalFicheHistory(corpusKey, id, ficheUnit, attributesUnit);
    }

    public static JunctionHistory toJunctionHistory(JunctionKey junctionKey, HistoryUnit junctionUnit) {
        return new InternalJunctionHistory(junctionKey, junctionUnit);
    }

    private static class InternalFicheHistory
    implements FicheHistory {
        private final SubsetKey corpusKey;
        private final int id;
        private final HistoryUnit ficheUnit;
        private final HistoryUnit attributesUnit;

        private InternalFicheHistory(SubsetKey corpusKey, int id, HistoryUnit ficheUnit, HistoryUnit attributesUnit) {
            this.corpusKey = corpusKey;
            this.id = id;
            this.ficheUnit = ficheUnit;
            this.attributesUnit = attributesUnit;
        }

        @Override
        public SubsetKey getCorpusKey() {
            return this.corpusKey;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public HistoryUnit getFicheUnit() {
            return this.ficheUnit;
        }

        @Override
        public HistoryUnit getAttributesUnit() {
            return this.attributesUnit;
        }
    }

    private static class InternalJunctionHistory
    implements JunctionHistory {
        private final JunctionKey junctionKey;
        private final HistoryUnit junctionUnit;

        private InternalJunctionHistory(JunctionKey junctionKey, HistoryUnit junctionUnit) {
            this.junctionKey = junctionKey;
            this.junctionUnit = junctionUnit;
        }

        @Override
        public JunctionKey getJunctionKey() {
            return this.junctionKey;
        }

        @Override
        public HistoryUnit getJunctionUnit() {
            return this.junctionUnit;
        }
    }
}

