/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.history;

import java.util.List;
import net.fichotheque.EditOrigin;

public interface HistoryUnit {
    public static final String CURRENT_REVISION = "current";
    public static final String PENULTIMATE_REVISION = "penultimate";

    public boolean isDeleted();

    public List<Revision> getRevisionList();

    default public boolean isEmpty() {
        return this.getRevisionList().isEmpty();
    }

    default public Revision getMostRecentRevision() {
        List<Revision> list = this.getRevisionList();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    default public EditOrigin getMostRecentEditOrigin() {
        Revision revision = this.getMostRecentRevision();
        if (revision == null) {
            return null;
        }
        return revision.getEditOriginList().get(0);
    }

    public static interface Revision {
        public String getName();

        public List<EditOrigin> getEditOriginList();
    }
}

