/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.extraction;

import net.fichotheque.SubsetKey;

public final class DataKey {
    private final SubsetKey subsetKey;
    private final String name;
    private final String keyString;

    public DataKey(SubsetKey subsetKey, String name) {
        if (subsetKey == null) {
            throw new IllegalArgumentException("subsetKey is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.subsetKey = subsetKey;
        this.name = name;
        this.keyString = subsetKey + "/" + name;
    }

    public SubsetKey getSubsetKey() {
        return this.subsetKey;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyString() {
        return this.keyString;
    }

    public String toString() {
        return this.keyString;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        DataKey otherKey = (DataKey)other;
        return otherKey.keyString.equals(this.keyString);
    }

    public int hashCode() {
        return this.keyString.hashCode();
    }
}

