/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.metadata;

import java.text.ParseException;
import net.fichotheque.corpus.metadata.AmountSubfieldKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.LangSubfieldKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.ExtendedCurrency;

public class SubfieldKey {
    public static final String SURNAME_SUBTYPE = "surname";
    public static final String FORENAME_SUBTYPE = "forename";
    public static final String SURNAMEFIRST_SUBTYPE = "surnamefirst";
    public static final String NONLATIN_SUBTYPE = "nonlatin";
    public static final String VALUE_SUBTYPE = "value";
    public static final String CURRENCY_SUBTYPE = "currency";
    public static final String LATITUDE_SUBTYPE = "lat";
    public static final String LONGITUDE_SUBTYPE = "lon";
    public static final String SRC_SUBTYPE = "src";
    public static final String ALT_SUBTYPE = "alt";
    public static final String TITLE_SUBTYPE = "title";
    public static final String OTHERS_SUBTYPE = "others";
    public static final String AMOUNT_SUBTYPE = "amount";
    public static final String LANG_SUBTYPE = "lang";
    protected final FieldKey fieldKey;
    protected final String subtype;

    protected SubfieldKey(FieldKey fieldKey, String subtype) {
        this.fieldKey = fieldKey;
        this.subtype = subtype;
    }

    public FieldKey getFieldKey() {
        return this.fieldKey;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public int hashCode() {
        return this.fieldKey.hashCode() + this.subtype.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        SubfieldKey fk = (SubfieldKey)other;
        if (!fk.subtype.equals(this.subtype)) {
            return false;
        }
        return fk.fieldKey.equals(this.fieldKey);
    }

    public String getKeyString() {
        return this.toString();
    }

    public String toString() {
        return this.fieldKey.getKeyString() + "_" + this.subtype;
    }

    public static SubfieldKey toSubfieldKey(FieldKey fieldKey, String type) {
        switch (type = SubfieldKey.checkSubtype(type)) {
            case "amount": {
                throw new IllegalArgumentException("Not use with AMOUNT_SUBTYPE");
            }
            case "lang": {
                throw new IllegalArgumentException("Not use with LANG_SUBTYPE");
            }
        }
        return new SubfieldKey(fieldKey, type);
    }

    public static SubfieldKey parse(String s) throws ParseException {
        int idx0 = s.indexOf(95);
        if (idx0 == -1) {
            throw new ParseException("No '_' character", 0);
        }
        int idx1 = s.indexOf(95, idx0 + 1);
        if (idx1 == -1) {
            throw new ParseException("Missing second '_' character", idx0);
        }
        FieldKey fieldKey = FieldKey.parse(s.substring(0, idx1));
        String subtype = s.substring(idx1 + 1);
        int idx2 = subtype.indexOf(95);
        String secondPart = "";
        if (idx2 > -1) {
            secondPart = subtype.substring(idx2 + 1);
            subtype = subtype.substring(0, idx2);
        }
        try {
            subtype = SubfieldKey.checkSubtype(subtype);
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException("Wrong subtype = " + subtype, idx1 + 1);
        }
        switch (subtype) {
            case "amount": {
                try {
                    ExtendedCurrency currency = ExtendedCurrency.parse(secondPart);
                    return new AmountSubfieldKey(fieldKey, currency);
                }
                catch (ParseException pe) {
                    throw new ParseException("Wrong currency = " + secondPart, idx2 + 1);
                }
            }
            case "lang": {
                try {
                    Lang lang = Lang.parse(secondPart);
                    return new LangSubfieldKey(fieldKey, lang);
                }
                catch (ParseException pe) {
                    throw new ParseException("Wrong lang = " + secondPart, idx2 + 1);
                }
            }
        }
        return new SubfieldKey(fieldKey, subtype);
    }

    public static SubfieldKey build(String s) {
        try {
            return SubfieldKey.parse(s);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static String checkSubtype(String subtype) {
        switch (subtype) {
            case "surname": 
            case "nom": {
                return SURNAME_SUBTYPE;
            }
            case "forename": 
            case "prenom": {
                return FORENAME_SUBTYPE;
            }
            case "surnamefirst": 
            case "nomavant": {
                return SURNAMEFIRST_SUBTYPE;
            }
            case "nonlatin": 
            case "original": {
                return NONLATIN_SUBTYPE;
            }
            case "value": {
                return VALUE_SUBTYPE;
            }
            case "currency": 
            case "cur": {
                return CURRENCY_SUBTYPE;
            }
            case "lat": 
            case "latitude": {
                return LATITUDE_SUBTYPE;
            }
            case "lon": 
            case "longitude": {
                return LONGITUDE_SUBTYPE;
            }
            case "src": {
                return SRC_SUBTYPE;
            }
            case "alt": {
                return ALT_SUBTYPE;
            }
            case "title": {
                return TITLE_SUBTYPE;
            }
            case "others": {
                return OTHERS_SUBTYPE;
            }
            case "amount": 
            case "montant": {
                return AMOUNT_SUBTYPE;
            }
            case "lang": {
                return LANG_SUBTYPE;
            }
        }
        throw new IllegalArgumentException("Wrong subtype = " + subtype);
    }

    public static boolean isLegalSubfield(CorpusField corpusField, String subfieldType) {
        switch (corpusField.getCategory()) {
            case 1: {
                switch (corpusField.getFicheItemType()) {
                    case "person": {
                        return SubfieldKey.isLegalPersonProp(subfieldType);
                    }
                    case "amount": {
                        return SubfieldKey.isLegalAmountProp(subfieldType);
                    }
                    case "geopoint": {
                        return SubfieldKey.isLegalGeopointProp(subfieldType);
                    }
                    case "image": {
                        return SubfieldKey.isLegalImageProp(subfieldType);
                    }
                }
                return false;
            }
            case 2: {
                switch (corpusField.getFicheItemType()) {
                    case "amount": {
                        return SubfieldKey.isLegalAmountInfo(subfieldType);
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static boolean isLegalImageProp(String subfieldType) {
        switch (subfieldType) {
            case "src": 
            case "alt": 
            case "title": {
                return true;
            }
        }
        return false;
    }

    private static boolean isLegalGeopointProp(String subfieldType) {
        switch (subfieldType) {
            case "lat": 
            case "lon": {
                return true;
            }
        }
        return false;
    }

    private static boolean isLegalPersonProp(String subfieldType) {
        switch (subfieldType) {
            case "surname": 
            case "forename": 
            case "surnamefirst": 
            case "nonlatin": {
                return true;
            }
        }
        return false;
    }

    private static boolean isLegalAmountProp(String subfieldType) {
        switch (subfieldType) {
            case "value": 
            case "currency": {
                return true;
            }
        }
        return false;
    }

    private static boolean isLegalAmountInfo(String subfieldType) {
        switch (subfieldType) {
            case "amount": 
            case "others": {
                return true;
            }
        }
        return false;
    }
}

