/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import net.fichotheque.corpus.fiche.AttConsumer;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.AttsImpl;

public class S
implements Serializable,
AttConsumer {
    private static final long serialVersionUID = 6L;
    public static final short EMPHASIS = 1;
    public static final short STRONG = 2;
    public static final short LINK = 3;
    public static final short EMSTRG = 4;
    public static final short IREF = 5;
    public static final short ANCHOR = 6;
    public static final short IMAGE = 7;
    public static final short FICHE = 8;
    public static final short CITE = 9;
    public static final short DEFINITION = 10;
    public static final short SAMPLE = 11;
    public static final short KEYBOARD = 12;
    public static final short VAR = 13;
    public static final short ABBR = 14;
    public static final short SPAN = 16;
    public static final short DELETE = 17;
    public static final short CODE = 18;
    public static final short INSERT = 19;
    public static final short BR = 20;
    public static final short SUP = 21;
    public static final short SUB = 22;
    public static final short QUOTE = 23;
    public static final short MOTCLE = 24;
    private final short type;
    private AttsImpl attsImpl;
    private String value = "";
    private String ref = "";

    public S(short type) {
        if (S.typeToString(type).isEmpty()) {
            throw new IllegalArgumentException("Unknown type: " + type);
        }
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public Atts getAtts() {
        return AttsImpl.check(this.attsImpl);
    }

    public String getRef() {
        return this.ref;
    }

    public String getValue() {
        return this.value;
    }

    public String getSyntax() {
        return AttsImpl.getSyntax(this.attsImpl);
    }

    public char getTypeInitial() {
        return S.typeToInitial(this.type);
    }

    @Override
    public void putAtt(String name, String value) {
        this.attsImpl = AttsImpl.put(this.attsImpl, name, value);
    }

    public void setValue(String s) {
        this.value = s == null ? "" : s;
    }

    public void setRef(String ref) {
        this.ref = ref != null ? ref : "";
    }

    public String toString() {
        return this.value;
    }

    public static String typeToString(short type) {
        switch (type) {
            case 1: {
                return "em";
            }
            case 2: {
                return "strg";
            }
            case 4: {
                return "emstrg";
            }
            case 3: {
                return "link";
            }
            case 6: {
                return "anchor";
            }
            case 5: {
                return "iref";
            }
            case 7: {
                return "img";
            }
            case 8: {
                return "fiche";
            }
            case 9: {
                return "cite";
            }
            case 10: {
                return "dfn";
            }
            case 11: {
                return "samp";
            }
            case 12: {
                return "kbd";
            }
            case 13: {
                return "var";
            }
            case 14: {
                return "abbr";
            }
            case 16: {
                return "span";
            }
            case 17: {
                return "del";
            }
            case 19: {
                return "ins";
            }
            case 20: {
                return "br";
            }
            case 21: {
                return "sup";
            }
            case 22: {
                return "sub";
            }
            case 18: {
                return "code";
            }
            case 23: {
                return "quote";
            }
            case 24: {
                return "motcle";
            }
        }
        return "";
    }

    public static short typeToShort(String typeString) {
        if (typeString.equals("em")) {
            return 1;
        }
        if (typeString.equals("strg")) {
            return 2;
        }
        if (typeString.equals("emstrg")) {
            return 4;
        }
        if (typeString.equals("link")) {
            return 3;
        }
        if (typeString.equals("note")) {
            return 5;
        }
        if (typeString.equals("iref")) {
            return 5;
        }
        if (typeString.equals("anchor")) {
            return 6;
        }
        if (typeString.equals("img")) {
            return 7;
        }
        if (typeString.equals("fiche")) {
            return 8;
        }
        if (typeString.equals("cite")) {
            return 9;
        }
        if (typeString.equals("dfn")) {
            return 10;
        }
        if (typeString.equals("samp")) {
            return 11;
        }
        if (typeString.equals("kbd")) {
            return 12;
        }
        if (typeString.equals("var")) {
            return 13;
        }
        if (typeString.equals("abbr") || typeString.equals("acronym")) {
            return 14;
        }
        if (typeString.equals("span")) {
            return 16;
        }
        if (typeString.equals("code")) {
            return 18;
        }
        if (typeString.equals("ins")) {
            return 19;
        }
        if (typeString.equals("del")) {
            return 17;
        }
        if (typeString.equals("quote")) {
            return 23;
        }
        if (typeString.equals("motcle")) {
            return 24;
        }
        if (typeString.equals("br")) {
            return 20;
        }
        if (typeString.equals("sup")) {
            return 21;
        }
        if (typeString.equals("sub")) {
            return 22;
        }
        throw new IllegalArgumentException("Unknown type: " + typeString);
    }

    private static char typeToInitial(short type) {
        switch (type) {
            case 20: {
                return '%';
            }
            case 6: {
                return '#';
            }
            case 5: {
                return '>';
            }
            case 21: {
                return '^';
            }
            case 12: {
                return '$';
            }
            case 22: {
                return '_';
            }
            case 9: {
                return '@';
            }
            case 3: {
                return 'a';
            }
            case 2: {
                return 'b';
            }
            case 18: {
                return '`';
            }
            case 10: {
                return '?';
            }
            case 1: {
                return 'e';
            }
            case 8: {
                return 'f';
            }
            case 7: {
                return 'i';
            }
            case 24: {
                return 'm';
            }
            case 23: {
                return ':';
            }
            case 11: {
                return '<';
            }
            case 14: {
                return '=';
            }
            case 19: {
                return '+';
            }
            case 13: {
                return '&';
            }
            case 4: {
                return 'w';
            }
            case 17: {
                return '-';
            }
            case 16: {
                return '*';
            }
        }
        throw new IllegalArgumentException("Wrong type value");
    }

    public static short initialToType(char carac) {
        switch (carac) {
            case '%': {
                return 20;
            }
            case '#': {
                return 6;
            }
            case '>': {
                return 5;
            }
            case '^': {
                return 21;
            }
            case '$': {
                return 12;
            }
            case '_': {
                return 22;
            }
            case '@': {
                return 9;
            }
            case 'a': {
                return 3;
            }
            case 'b': {
                return 2;
            }
            case '`': 
            case 'c': {
                return 18;
            }
            case '?': {
                return 10;
            }
            case 'e': {
                return 1;
            }
            case 'f': {
                return 8;
            }
            case 'i': {
                return 7;
            }
            case 'm': {
                return 24;
            }
            case ':': 
            case 'q': {
                return 23;
            }
            case '<': {
                return 11;
            }
            case '=': {
                return 14;
            }
            case '+': {
                return 19;
            }
            case '&': 
            case 'v': {
                return 13;
            }
            case 'w': {
                return 4;
            }
            case '-': {
                return 17;
            }
            case '*': {
                return 16;
            }
        }
        throw new IllegalArgumentException("Wrong carac value");
    }

    public static boolean isSpecialRef(short type) {
        switch (type) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTypoType(short type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRefDefaultValue(short type) {
        switch (type) {
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIref(short type) {
        switch (type) {
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }
}

