/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import net.fichotheque.corpus.fiche.FicheItem;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.text.StringUtils;

public final class PersonItem
implements FicheItem,
Serializable {
    private static final long serialVersionUID = 6L;
    private InternalPersonCore personCore;
    private String userGlobalId;
    private String organism;

    public PersonItem(String userGlobalId) {
        if (userGlobalId == null) {
            throw new IllegalArgumentException("redacteurGlobalId is null");
        }
        this.userGlobalId = userGlobalId;
    }

    public PersonItem(PersonCore personCore, String organism) {
        if (personCore == null) {
            throw new IllegalArgumentException("personCore is null");
        }
        this.personCore = new InternalPersonCore(personCore);
        if ((organism = StringUtils.cleanString(organism)) != null && organism.length() == 0) {
            organism = null;
        }
        this.organism = organism;
    }

    public String getRedacteurGlobalId() {
        return this.userGlobalId;
    }

    public PersonCore getPersonCore() {
        if (this.personCore == null) {
            throw new UnsupportedOperationException();
        }
        return this.personCore;
    }

    public String getOrganism() {
        return this.organism;
    }

    public String toString() {
        if (this.userGlobalId != null) {
            return this.userGlobalId;
        }
        return this.personCore.toBiblioStyle(false);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PersonItem)) {
            return false;
        }
        PersonItem other = (PersonItem)obj;
        if (other.userGlobalId != null) {
            if (this.userGlobalId == null) {
                return false;
            }
            return other.userGlobalId.equals(this.userGlobalId);
        }
        if (this.userGlobalId != null) {
            return false;
        }
        boolean result = PersonCoreUtils.areEqual(this.personCore, other.personCore);
        if (!result) {
            return false;
        }
        if (other.organism == null) {
            return this.organism == null;
        }
        if (this.organism == null) {
            return false;
        }
        return other.organism.equals(this.organism);
    }

    public int hashCode() {
        if (this.userGlobalId != null) {
            return this.userGlobalId.hashCode();
        }
        return this.personCore.getSurname().hashCode() + this.personCore.getForename().hashCode();
    }

    private static class InternalPersonCore
    implements PersonCore,
    Serializable {
        private final String surname;
        private final String forename;
        private final String nonlatin;
        private final boolean surnameFirst;

        private InternalPersonCore(PersonCore personCore) {
            this.surname = personCore.getSurname();
            this.forename = personCore.getForename();
            this.nonlatin = personCore.getNonlatin();
            this.surnameFirst = personCore.isSurnameFirst();
        }

        @Override
        public String getSurname() {
            return this.surname;
        }

        @Override
        public String getForename() {
            return this.forename;
        }

        @Override
        public String getNonlatin() {
            return this.nonlatin;
        }

        @Override
        public boolean isSurnameFirst() {
            return this.surnameFirst;
        }
    }
}

