/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.util.List;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Info;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.localisation.Lang;

public interface FicheAPI {
    public String getTitle();

    public Lang getLang();

    public ParaItem getSubtitle();

    public FicheItems getOwners();

    public List<Prop> getPropList();

    public List<Info> getInfoList();

    public List<Section> getSectionList();

    public Prop getProp(FieldKey var1);

    public Info getInfo(FieldKey var1);

    public Section getSection(FieldKey var1);

    default public Object getValue(FieldKey fieldKey) {
        switch (fieldKey.getCategory()) {
            case 1: {
                Prop prop = this.getProp(fieldKey);
                if (prop == null) {
                    return null;
                }
                return prop.getFicheItem();
            }
            case 2: {
                return this.getInfo(fieldKey);
            }
            case 3: {
                return this.getSection(fieldKey);
            }
            case 0: {
                switch (fieldKey.getKeyString()) {
                    case "title": {
                        String title = this.getTitle();
                        if (title.isEmpty()) {
                            return null;
                        }
                        return title;
                    }
                    case "subtitle": {
                        return this.getSubtitle();
                    }
                    case "lang": {
                        Lang lang = this.getLang();
                        if (lang == null) {
                            return null;
                        }
                        return new LanguageItem(lang);
                    }
                    case "owners": {
                        return this.getOwners();
                    }
                    case "id": {
                        throw new IllegalArgumentException("FieldKey.ID is not contained in FicheAPI ");
                    }
                }
                return null;
            }
        }
        return null;
    }

    default public Object getValue(CorpusField corpusField) {
        return this.getValue(corpusField.getFieldKey());
    }
}

