/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.zip;

import fr.exemole.bdfserver.api.BdfServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.utils.EligibilityUtils;
import net.mapeadores.util.io.IOUtils;

public class BackupZip {
    private final SubsetEligibility subsetEligibility;
    private final BdfServer bdfServer;

    public BackupZip(BdfServer bdfServer, SubsetEligibility subsetEligibility) {
        this.bdfServer = bdfServer;
        this.subsetEligibility = subsetEligibility == null ? EligibilityUtils.ALL_SUBSET_ELIGIBILITY : subsetEligibility;
    }

    public void zip(ZipOutputStream zipOutputStream) throws IOException {
        File backupDir = this.bdfServer.getBdfServerDirs().getDir("var.backup");
        if (backupDir == null || !backupDir.isDirectory()) {
            return;
        }
        this.zipDir(zipOutputStream, backupDir, "backup");
    }

    private void zipDir(ZipOutputStream zipOutputStream, File dir, String path) throws IOException {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.zipDir(zipOutputStream, f, path + "/" + f.getName());
                continue;
            }
            zipOutputStream.putNextEntry(new ZipEntry(path + "/" + f.getName()));
            try (FileInputStream is = new FileInputStream(f);){
                IOUtils.copy((InputStream)is, (OutputStream)zipOutputStream);
            }
        }
    }
}

