/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.roles.dom;

import fr.exemole.bdfserver.api.roles.FichePermission;
import fr.exemole.bdfserver.tools.roles.RoleDefBuilder;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RoleDefDOMReader {
    private final RoleDefBuilder roleDefBuilder;
    private final MessageHandler messageHandler;

    public RoleDefDOMReader(RoleDefBuilder roleDefBuilder, MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.roleDefBuilder = roleDefBuilder;
    }

    public RoleDefDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static RoleDefDOMReader init(RoleDefBuilder roleDefBuilder, MessageHandler messageHandler) {
        return new RoleDefDOMReader(roleDefBuilder, messageHandler);
    }

    private void readOldLibList(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    LabelUtils.readLabel(element, this.roleDefBuilder);
                }
                catch (ParseException ile) {
                    DomMessages.wrongLangAttribute(this.messageHandler, tagName, element.getAttribute("xml:lang"));
                }
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagName);
        }
    }

    private void readSubsetPermission(Element element_xml) {
        SubsetKey subsetKey;
        try {
            subsetKey = SubsetKey.parse(element_xml.getAttribute("subset"));
        }
        catch (ParseException pe) {
            return;
        }
        short level = this.readLevel(element_xml);
        if (level < 0) {
            return;
        }
        FichePermission customPermission = null;
        if (level == 2) {
            if (subsetKey.isCorpusSubset()) {
                boolean create = false;
                short read = 0;
                short write = 0;
                NodeList liste = element_xml.getChildNodes();
                for (int i = 0; i < liste.getLength(); ++i) {
                    short type;
                    if (liste.item(i).getNodeType() != 1) continue;
                    Element element = (Element)liste.item(i);
                    String tagName = element.getTagName();
                    if (tagName.equals("create")) {
                        create = true;
                        continue;
                    }
                    if (tagName.equals("read")) {
                        type = this.readFichePermissionType(element);
                        if (type == 0) continue;
                        read = type;
                        continue;
                    }
                    if (tagName.equals("write")) {
                        type = this.readFichePermissionType(element);
                        if (type == 0) continue;
                        write = type;
                        continue;
                    }
                    DomMessages.unknownTagWarning(this.messageHandler, tagName);
                }
                if (read == 0) {
                    level = 0;
                } else {
                    customPermission = RoleUtils.toFichePermission(create, read, write);
                    if (RoleUtils.matchStandardPermission(customPermission)) {
                        level = 1;
                        customPermission = null;
                    }
                }
            } else {
                level = 1;
            }
        }
        this.roleDefBuilder.putSubsetPermission(subsetKey, RoleUtils.toPermission(level, customPermission));
    }

    private void readOldCorpusPermission(Element element_xml) {
        int level;
        SubsetKey corpusKey;
        String corpusName = element_xml.getAttribute("corpus");
        try {
            corpusKey = SubsetKey.parse((short)1, corpusName);
        }
        catch (ParseException pe) {
            return;
        }
        boolean create = false;
        short read = 0;
        short write = 0;
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            short type;
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagName = element.getTagName();
            if (tagName.equals("create-fiche")) {
                create = true;
                continue;
            }
            if (tagName.equals("read-fiche")) {
                type = this.readFichePermissionType(element);
                if (type == 0) continue;
                read = type;
                continue;
            }
            if (tagName.equals("write-fiche")) {
                type = this.readFichePermissionType(element);
                if (type == 0) continue;
                write = type;
                continue;
            }
            if (tagName.equals("send-fiche")) continue;
            DomMessages.unknownTagWarning(this.messageHandler, tagName);
        }
        FichePermission fichePermission = null;
        if (read == 0) {
            level = 0;
        } else {
            fichePermission = RoleUtils.toFichePermission(create, read, write);
            if (RoleUtils.matchStandardPermission(fichePermission)) {
                level = 1;
                fichePermission = null;
            } else {
                level = 2;
            }
        }
        this.roleDefBuilder.putSubsetPermission(corpusKey, RoleUtils.toPermission((short)level, fichePermission));
    }

    private short readFichePermissionType(Element element_xml) {
        String typeString = element_xml.getAttribute("type");
        if (typeString.length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, element_xml.getTagName(), "type");
            return 0;
        }
        try {
            return RoleUtils.fichePermissionTypeToShort(typeString);
        }
        catch (IllegalArgumentException iae) {
            DomMessages.wrongAttributeValue(this.messageHandler, element_xml.getTagName(), "type", typeString);
            return 0;
        }
    }

    private short readLevel(Element element_xml) {
        String levelString = element_xml.getAttribute("level");
        if (levelString.length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, element_xml.getTagName(), "level");
            return -1;
        }
        try {
            return RoleUtils.levelToShort(levelString);
        }
        catch (IllegalArgumentException iae) {
            DomMessages.wrongAttributeValue(this.messageHandler, element_xml.getTagName(), "level", levelString);
            return -1;
        }
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "lib-list": {
                    RoleDefDOMReader.this.readOldLibList(element);
                    break;
                }
                case "corpus-permission": {
                    RoleDefDOMReader.this.readOldCorpusPermission(element);
                    break;
                }
                case "subset-permission": {
                    RoleDefDOMReader.this.readSubsetPermission(element);
                    break;
                }
                case "label": 
                case "lib": {
                    try {
                        LabelUtils.readLabel(element, RoleDefDOMReader.this.roleDefBuilder);
                    }
                    catch (ParseException ile) {
                        DomMessages.wrongLangAttribute(RoleDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(RoleDefDOMReader.this.roleDefBuilder.getAttributesBuilder(), element);
                    break;
                }
                default: {
                    DomMessages.unknownTagWarning(RoleDefDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }
}

