/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.overview;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerConstants;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.overview.CommentBlock;
import fr.exemole.bdfserver.tools.overview.ExternalDataBlock;
import fr.exemole.bdfserver.tools.overview.FieldBlock;
import fr.exemole.bdfserver.tools.overview.MetadataBlock;
import fr.exemole.bdfserver.tools.overview.SpecialIncludeBlock;
import fr.exemole.bdfserver.tools.overview.SubsetIncludeBlock;
import java.util.List;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.include.ExtendedIncludeKey;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LineMessageException;
import net.mapeadores.util.text.CleanedString;

public abstract class OverviewBlock {
    private final int lineNumber;
    private final String name;

    OverviewBlock(int lineNumber, UiComponent uiComponent) {
        this.lineNumber = lineNumber;
        this.name = uiComponent.getName();
    }

    OverviewBlock(int lineNumber, String name) {
        this.lineNumber = lineNumber;
        this.name = name;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getName() {
        return this.name;
    }

    public void addAttribute(AttributeKey attributeKey, List<CleanedString> list) {
        AttributeChangeBuilder attributeChangeBuilder = this.getAttributeChangeBuilder();
        if (list.isEmpty()) {
            attributeChangeBuilder.putRemovedAttributeKey(attributeKey);
        } else {
            attributeChangeBuilder.appendValues(attributeKey, list);
        }
    }

    public abstract boolean addText(String var1, Lang var2, String var3);

    public abstract AttributeChangeBuilder getAttributeChangeBuilder();

    public abstract void firstPass(EditSession var1, UiComponents var2);

    public abstract void secondPass(EditSession var1, UiComponents var2);

    public abstract void put(int var1, String var2, String var3) throws LineMessageException;

    public abstract void put(int var1, String var2, String var3, String var4) throws LineMessageException;

    public String checkStatus(int lineNumber, String value) throws LineMessageException {
        try {
            return BdfServerConstants.checkValidStatus(value);
        }
        catch (IllegalArgumentException iae) {
            throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.parametervalue", "status", value);
        }
    }

    public Object parseOptionValue(String optionName, String optionValue) {
        return optionValue;
    }

    public static OverviewBlock fromUiComponent(int lineNumber, BdfServer bdfServer, UiComponent uiComponent, CorpusMetadata corpusMetadata) {
        if (uiComponent instanceof FieldUi) {
            return new FieldBlock(lineNumber, (FieldUi)uiComponent, corpusMetadata);
        }
        if (uiComponent instanceof SubsetIncludeUi) {
            return new SubsetIncludeBlock(lineNumber, (SubsetIncludeUi)uiComponent);
        }
        if (uiComponent instanceof SpecialIncludeUi) {
            return new SpecialIncludeBlock(lineNumber, (SpecialIncludeUi)uiComponent);
        }
        if (uiComponent instanceof DataUi) {
            return new ExternalDataBlock(lineNumber, (DataUi)uiComponent);
        }
        if (uiComponent instanceof CommentUi) {
            return new CommentBlock(lineNumber, bdfServer, (CommentUi)uiComponent);
        }
        throw new ClassCastException("Unknown implementation: " + uiComponent.getClass().getCanonicalName());
    }

    public static OverviewBlock metadata(int lineNumber, CorpusMetadata corpusMetadata) {
        return new MetadataBlock(lineNumber, corpusMetadata);
    }

    public static OverviewBlock fieldKey(int lineNumber, FieldKey fieldKey, String ficheItemType, CorpusMetadata corpusMetadata) {
        return new FieldBlock(lineNumber, fieldKey, ficheItemType, corpusMetadata);
    }

    public static OverviewBlock includeKey(int lineNumber, ExtendedIncludeKey includeKey) {
        return new SubsetIncludeBlock(lineNumber, includeKey);
    }

    public static OverviewBlock specialInclude(int lineNumber, String specialIncludeName) {
        return new SpecialIncludeBlock(lineNumber, specialIncludeName);
    }

    public static OverviewBlock externalData(int lineNumber, String dataName, String type) {
        return new ExternalDataBlock(lineNumber, dataName, type);
    }

    public static OverviewBlock comment(int lineNumber, BdfServer bdfServer, String commentName) {
        return new CommentBlock(lineNumber, bdfServer, commentName);
    }
}

