/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.logging.CommandMessage;

public class BdfCommandResultBuilder {
    private final Map<String, Object> resultObjectMap = new HashMap<String, Object>();
    private CommandMessage commandMessage;

    public BdfCommandResultBuilder putResultObject(String name, Object obj) {
        this.resultObjectMap.put(name, obj);
        return this;
    }

    public BdfCommandResultBuilder setCommandMessage(CommandMessage commandMessage) {
        this.commandMessage = commandMessage;
        return this;
    }

    public BdfCommandResult toBdfCommandResult() {
        return new InternalBdfCommandResult(this.resultObjectMap, this.commandMessage);
    }

    public static BdfCommandResultBuilder init() {
        return new BdfCommandResultBuilder();
    }

    private static class InternalBdfCommandResult
    implements BdfCommandResult {
        private final Map<String, Object> resultObjectMap;
        private final CommandMessage commandMessage;
        private final Set<String> resultObjectNameSet;

        private InternalBdfCommandResult(Map<String, Object> resultObjectMap, CommandMessage commandMessage) {
            this.resultObjectMap = resultObjectMap;
            this.resultObjectNameSet = Collections.unmodifiableSet(resultObjectMap.keySet());
            this.commandMessage = commandMessage;
        }

        @Override
        public Object getResultObject(String name) {
            return this.resultObjectMap.get(name);
        }

        @Override
        public CommandMessage getCommandMessage() {
            return this.commandMessage;
        }

        @Override
        public Set<String> getResultObjectNameSet() {
            return this.resultObjectNameSet;
        }
    }
}

