/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders.thesaurus;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.include.SubsetItemValue;
import fr.exemole.bdfserver.api.ficheform.include.ThesaurusEntry;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.builders.thesaurus.MotcleValueListBuilder;
import java.util.Collection;
import java.util.List;
import net.fichotheque.junction.Liaison;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;

public class HiddenThesaurusEntryBuilder {
    private final String name;
    private final Thesaurus thesaurus;
    private final MotcleValueListBuilder motcleValueListBuilder = new MotcleValueListBuilder();
    private String label = "";
    private boolean mandatory = false;
    private String value = "";
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;

    public HiddenThesaurusEntryBuilder(String name, Thesaurus thesaurus) {
        this.name = name;
        this.thesaurus = thesaurus;
    }

    public HiddenThesaurusEntryBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public HiddenThesaurusEntryBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public HiddenThesaurusEntryBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public HiddenThesaurusEntryBuilder setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = value;
        return this;
    }

    public ThesaurusEntry.Hidden toHiddenThesaurusEntry() {
        return new InternalHiddenThesaurusEntry(this.name, this.label, this.mandatory, this.attributes, this.thesaurus, this.value, this.motcleValueListBuilder.toList());
    }

    @Nullable
    public static HiddenThesaurusEntryBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, SubsetIncludeUi includeUi) {
        String value;
        Thesaurus thesaurus = (Thesaurus)ficheFormParameters.getBdfServer().getFichotheque().getSubset(includeUi.getSubsetKey());
        if (thesaurus == null) {
            return null;
        }
        HiddenThesaurusEntryBuilder builder = HiddenThesaurusEntryBuilder.init(includeUi.getName(), thesaurus).setAttributes(includeUi.getAttributes());
        SubsetItemPointeur pointeur = FicheFormUtils.checkMasterPointeur(fichePointeur, ficheFormParameters, includeUi);
        if (pointeur.isEmpty()) {
            builder.motcleValueListBuilder.populateDefault(ficheFormParameters, includeUi, thesaurus);
            value = FicheFormUtils.getDefVal(ficheFormParameters, includeUi);
        } else {
            Collection<Liaison> liaisons = builder.motcleValueListBuilder.populate(pointeur.getJunctions(thesaurus), includeUi, true);
            value = FicheFormUtils.getStringValue(thesaurus, liaisons, includeUi, ficheFormParameters);
        }
        if (builder.motcleValueListBuilder.isEmpty() && includeUi.isObsolete()) {
            return null;
        }
        return builder.setValue(value);
    }

    public static HiddenThesaurusEntryBuilder init(String name, Thesaurus thesaurus) {
        return new HiddenThesaurusEntryBuilder(name, thesaurus);
    }

    private static class InternalHiddenThesaurusEntry
    implements ThesaurusEntry.Hidden {
        private final String name;
        private final String label;
        private final boolean mandatory;
        private final Attributes attributes;
        private final Thesaurus thesaurus;
        private final String value;
        private final List<SubsetItemValue> list;

        private InternalHiddenThesaurusEntry(String name, String label, boolean mandatory, Attributes attributes, Thesaurus thesaurus, String value, List<SubsetItemValue> list) {
            this.name = name;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.thesaurus = thesaurus;
            this.value = value;
            this.list = list;
        }

        @Override
        public String getIncludeName() {
            return this.name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public Thesaurus getThesaurus() {
            return this.thesaurus;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public Attribute getIdalphaStyle() {
            return null;
        }

        @Override
        public List<SubsetItemValue> getValueList() {
            return this.list;
        }
    }
}

