/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.diagnostic.urlscan;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.StorageRoot;
import fr.exemole.bdfserver.tools.diagnostic.urlscan.UrlReport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.http.UrlStatus;
import net.mapeadores.util.http.UrlStatusPrimitives;
import net.mapeadores.util.primitives.io.PrimitivesIOFactory;
import net.mapeadores.util.primitives.io.PrimitivesReader;
import net.mapeadores.util.primitives.io.PrimitivesWriter;
import net.mapeadores.util.text.RelativePath;

public class UrlReportCache {
    private static final long CACHE_DURATION = 1296000000L;
    private static final long ONE_DAY_CACHE_DURATION = 86400000L;
    private static final RelativePath DIR_PATH = RelativePath.build("urlstatus");
    private final BdfServer bdfServer;
    private final StorageRoot cacheStorage;
    private final File cacheDir;
    private final StorageRoot.Lock lock;

    public UrlReportCache(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
        this.cacheStorage = bdfServer.getCacheStorage();
        this.cacheDir = this.cacheStorage.getFile(DIR_PATH);
        this.lock = this.cacheStorage.getLock(DIR_PATH);
        this.cacheDir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Collection<UrlReport> reports, boolean append) {
        File file = this.getCacheFile();
        StorageRoot.Lock lock = this.lock;
        synchronized (lock) {
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file, append));){
                PrimitivesWriter dataPrimitivesWriter = PrimitivesIOFactory.newWriter(os);
                for (UrlReport report : reports) {
                    dataPrimitivesWriter.writeString(report.getUrl());
                    dataPrimitivesWriter.writeLong(report.getTime());
                    UrlStatusPrimitives.writeUrlStatus(report.getUrlStatus(), dataPrimitivesWriter);
                }
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, UrlReport> read() {
        HashMap<String, UrlReport> map = new HashMap<String, UrlReport>();
        File file = this.getCacheFile();
        if (!file.exists()) {
            return map;
        }
        StorageRoot.Lock lock = this.lock;
        synchronized (lock) {
            long currentTime = System.currentTimeMillis();
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                try {
                    PrimitivesReader primitivesReader = PrimitivesIOFactory.newReader(is);
                    while (true) {
                        String url = primitivesReader.readString();
                        long time = primitivesReader.readLong();
                        UrlStatus urlStatus = UrlStatusPrimitives.readUrlStatus(primitivesReader);
                        if (!UrlReportCache.isStillValid(urlStatus, time, currentTime)) continue;
                        map.put(url, new UrlReport(url, urlStatus, time));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (EOFException is) {
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
        return map;
    }

    private File getCacheFile() {
        return new File(this.cacheDir, "urlstatus.primitives");
    }

    private static boolean isStillValid(UrlStatus urlStatus, long time, long currentTime) {
        long cacheDuration = UrlReportCache.getCacheDuration(urlStatus);
        return currentTime - time < 1296000000L;
    }

    private static long getCacheDuration(UrlStatus urlStatus) {
        if (urlStatus.hasResponse() && urlStatus.getResponseCode() >= 500) {
            return 86400000L;
        }
        return 1296000000L;
    }
}

