/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.configuration;

import fr.exemole.bdfserver.api.configuration.LangConfiguration;
import java.util.LinkedHashSet;
import java.util.Set;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;

public class LangConfigurationBuilder {
    private final Set<Lang> workingSet = new LinkedHashSet<Lang>();
    private final Set<Lang> supplementarySet = new LinkedHashSet<Lang>();
    private boolean allLanguages = false;
    private boolean withNonlatin = false;
    private boolean withoutSurnameFirst = false;

    public LangConfigurationBuilder addWorkingLang(Lang workingLang) {
        this.workingSet.add(workingLang);
        this.supplementarySet.remove(workingLang);
        return this;
    }

    public LangConfigurationBuilder addSupplementaryLang(Lang supplementaryLang) {
        if (!this.workingSet.contains(supplementaryLang)) {
            this.supplementarySet.add(supplementaryLang);
        }
        return this;
    }

    public LangConfigurationBuilder setAllLanguages(boolean allLanguages) {
        this.allLanguages = allLanguages;
        return this;
    }

    public LangConfigurationBuilder setWithNonlatin(boolean withNonlatin) {
        this.withNonlatin = withNonlatin;
        return this;
    }

    public LangConfigurationBuilder setWithoutSurnameFirst(boolean withoutSurnameFirst) {
        this.withoutSurnameFirst = withoutSurnameFirst;
        return this;
    }

    public LangConfiguration toLangConfiguration() {
        Langs workingLangs = this.workingSet.isEmpty() ? LangsUtils.wrap(Lang.build("fr")) : LangsUtils.fromCollection(this.workingSet);
        Langs supplementaryLangs = LangsUtils.fromCollection(this.supplementarySet);
        return new InternalLangConfiguration(workingLangs, supplementaryLangs, this.allLanguages, this.withNonlatin, this.withoutSurnameFirst);
    }

    public static LangConfigurationBuilder init() {
        return new LangConfigurationBuilder();
    }

    private static class InternalLangConfiguration
    implements LangConfiguration {
        private final Langs workingLangs;
        private final Langs supplementaryLangs;
        private final boolean allLanguages;
        private final boolean withNonlatin;
        private final boolean withoutSurnameFirst;

        private InternalLangConfiguration(Langs workingLangs, Langs supplementaryLangs, boolean allLanguages, boolean withNonlatin, boolean withoutSurnameFirst) {
            this.workingLangs = workingLangs;
            this.supplementaryLangs = supplementaryLangs;
            this.allLanguages = allLanguages;
            this.withNonlatin = withNonlatin;
            this.withoutSurnameFirst = withoutSurnameFirst;
        }

        @Override
        public Langs getWorkingLangs() {
            return this.workingLangs;
        }

        @Override
        public Langs getSupplementaryLangs() {
            return this.supplementaryLangs;
        }

        @Override
        public boolean isAllLanguages() {
            return this.allLanguages;
        }

        @Override
        public boolean isWithNonlatin() {
            return this.withNonlatin;
        }

        @Override
        public boolean isWithoutSurnameFirst() {
            return this.withoutSurnameFirst;
        }
    }
}

