/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.balayage.BalayageTemplate;
import fr.exemole.bdfserver.api.balayage.TemplateProvider;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.tools.BdfURI;
import fr.exemole.bdfserver.tools.balayage.BdfBalayageUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.exportation.transformation.NoDefaultTemplateException;
import net.fichotheque.exportation.transformation.SimpleTemplate;
import net.fichotheque.exportation.transformation.StreamTemplate;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.NestedTransformerException;
import net.mapeadores.util.io.BufferErrorListener;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.text.ValidExtension;

public class TemplateProviderBuilder {
    private static final Map<String, String> EMPTY_OUTPUTPROPERTIES = Collections.emptyMap();
    private final ErrorHandler errorHandler;
    private final BdfServer bdfServer;
    private final PathConfiguration pathConfiguration;
    private final BalayageDef balayageDef;
    private URIResolver customURIResolver;

    public TemplateProviderBuilder(BdfServer bdfServer, PathConfiguration pathConfiguration, BalayageDef balayageDef, ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.bdfServer = bdfServer;
        this.pathConfiguration = pathConfiguration;
        this.balayageDef = balayageDef;
    }

    public void setCustomURIResolver(URIResolver customURIResolver) {
        this.customURIResolver = customURIResolver;
    }

    public TemplateProvider build(BalayageOutput output) {
        String xsltPath = output.getXsltPath();
        if (xsltPath.isEmpty()) {
            this.errorHandler.undefinedXslPath();
            return null;
        }
        if (xsltPath.startsWith("bdf:")) {
            return this.buildFromTransformationKey(output, xsltPath.substring(4));
        }
        return this.buildFromBalayage(output, xsltPath);
    }

    private TemplateProvider buildFromBalayage(BalayageOutput output, String xsltPath) {
        Source transformerSource = BdfBalayageUtils.getTransformerSource(this.bdfServer, this.balayageDef, xsltPath);
        if (transformerSource == null) {
            this.errorHandler.wrongXslPath(xsltPath);
            return null;
        }
        BufferErrorListener errorListener = new BufferErrorListener();
        URIResolver uriResolver = this.customURIResolver != null ? this.customURIResolver : BdfURI.getURIResolver(this.bdfServer, this.pathConfiguration);
        uriResolver = BdfTransformationUtils.wrap(uriResolver);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver(uriResolver);
        factory.setErrorListener(errorListener);
        Transformer transformer = null;
        try {
            transformer = factory.newTransformer(transformerSource);
            transformer.setErrorListener(errorListener);
            transformer.setURIResolver(uriResolver);
        }
        catch (TransformerException te) {
            errorListener.addError(te);
        }
        if (errorListener.hasError()) {
            this.errorHandler.transformerError(xsltPath, errorListener);
            return null;
        }
        return new XsltTemplateProvider(output, transformer);
    }

    private TemplateProvider buildFromTransformationKey(BalayageOutput output, String templateName) {
        int idx;
        if (!output.getBalayageUnit().getType().equals("fiche")) {
            this.errorHandler.wrongBalayageUnitType();
            return null;
        }
        String extension = null;
        if (templateName != null && (idx = templateName.indexOf(46)) != -1) {
            templateName = templateName.substring(0, idx);
            extension = templateName.substring(idx + 1);
        }
        if (templateName.length() == 0 || templateName.equals("_default")) {
            templateName = null;
        }
        TransformationManager transformationManager = this.bdfServer.getTransformationManager();
        HashMap<SubsetKey, TransformationKeyBalayageTemplate> templateMap = new HashMap<SubsetKey, TransformationKeyBalayageTemplate>();
        for (Corpus corpus : this.bdfServer.getFichotheque().getCorpusList()) {
            TemplateKey templateKey;
            SubsetKey corpusKey = corpus.getSubsetKey();
            TransformationKey transformationKey = new TransformationKey(corpusKey);
            if (extension != null) {
                StreamTemplate streamTemplate;
                try {
                    ValidExtension validExtension = ValidExtension.parse(extension);
                    templateKey = TemplateKey.parse(transformationKey, validExtension, templateName);
                }
                catch (ParseException pe) {
                    return null;
                }
                try {
                    streamTemplate = transformationManager.getStreamTemplate(templateKey, false);
                    if (streamTemplate == null) {
                        return null;
                    }
                }
                catch (NoDefaultTemplateException ndte) {
                    return null;
                }
                if (!(streamTemplate instanceof StreamTemplate.Xslt)) {
                    return null;
                }
                templateMap.put(corpusKey, new StreamTransformationKeyBalayageTemplate((StreamTemplate.Xslt)streamTemplate));
                continue;
            }
            try {
                templateKey = TemplateKey.parse(transformationKey, templateName);
            }
            catch (ParseException pe) {
                return null;
            }
            SimpleTemplate simpleTemplate = transformationManager.getSimpleTemplate(templateKey, false);
            if (simpleTemplate == null) {
                return null;
            }
            templateMap.put(corpusKey, new SimpleTransformationKeyBalayageTemplate(simpleTemplate));
        }
        return new TransformationKeyTemplateProvider(output, templateMap, this.bdfServer.getDefaultWorkingLang().toString());
    }

    public static interface ErrorHandler {
        public void wrongBalayageUnitType();

        public void transformerError(String var1, BufferErrorListener var2);

        public void undefinedXslPath();

        public void wrongXslPath(String var1);
    }

    private static class XsltTemplateProvider
    extends AbstractTemplateProvider {
        private final XsltBalayageTemplate xsltBalayageTemplate;

        XsltTemplateProvider(BalayageOutput output, Transformer transformer) {
            super(output);
            this.xsltBalayageTemplate = new XsltBalayageTemplate(transformer);
        }

        @Override
        public BalayageTemplate getBalayageTemplate(Object extractionObject) {
            this.initParameters(this.xsltBalayageTemplate.getTransformer());
            return this.xsltBalayageTemplate;
        }
    }

    private static class StreamTransformationKeyBalayageTemplate
    extends TransformationKeyBalayageTemplate {
        private final StreamTemplate.Xslt streamTemplate;

        private StreamTransformationKeyBalayageTemplate(StreamTemplate.Xslt streamTemplate) {
            this.streamTemplate = streamTemplate;
        }

        @Override
        public String getMimeType() {
            return this.streamTemplate.getMimeType();
        }

        @Override
        public String getCharset() {
            return null;
        }

        @Override
        public void transform(String extractionString, OutputStream outputStream) {
            try {
                this.streamTemplate.transform(extractionString, outputStream, this.transformerParameters, EMPTY_OUTPUTPROPERTIES);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
    }

    private static class SimpleTransformationKeyBalayageTemplate
    extends TransformationKeyBalayageTemplate {
        private final SimpleTemplate simpleTemplate;

        private SimpleTransformationKeyBalayageTemplate(SimpleTemplate simpleTemplate) {
            this.simpleTemplate = simpleTemplate;
        }

        @Override
        public String getMimeType() {
            return this.simpleTemplate.getMimeType();
        }

        @Override
        public String getCharset() {
            return this.simpleTemplate.getCharset();
        }

        @Override
        public void transform(String extractionString, OutputStream outputStream) {
            String s = this.simpleTemplate.transform(extractionString, (Map<String, Object>)this.transformerParameters);
            try {
                StringReader reader = new StringReader(s);
                IOUtils.copy(reader, outputStream, this.simpleTemplate.getCharset());
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
    }

    private static class TransformationKeyTemplateProvider
    extends AbstractTemplateProvider {
        private final Map<SubsetKey, TransformationKeyBalayageTemplate> templateMap;
        private final String defaultLang;

        TransformationKeyTemplateProvider(BalayageOutput output, Map<SubsetKey, TransformationKeyBalayageTemplate> templateMap, String defaultLang) {
            super(output);
            this.templateMap = templateMap;
            this.defaultLang = defaultLang;
        }

        @Override
        public BalayageTemplate getBalayageTemplate(Object extractionObject) {
            FicheMeta ficheMeta = (FicheMeta)extractionObject;
            SubsetKey corpusKey = ficheMeta.getSubsetKey();
            TransformationKeyBalayageTemplate template = this.templateMap.get(corpusKey);
            template.update(this.getTransformerParameters());
            return template;
        }

        @Override
        public void setCurrentLang(String lang) {
            this.setFollowingParam("BDF_LANG", lang);
            if (lang == null) {
                lang = this.defaultLang;
            }
            this.setFollowingParam("WORKINGLANG", lang);
        }
    }

    private static abstract class TransformationKeyBalayageTemplate
    implements BalayageTemplate {
        Map<String, Object> transformerParameters;
        Map<String, String> outputProperties = new HashMap<String, String>();

        private TransformationKeyBalayageTemplate() {
        }

        void update(Map<String, Object> transformerParameters) {
            this.transformerParameters = transformerParameters;
        }
    }

    private static class XsltBalayageTemplate
    implements BalayageTemplate {
        private final Transformer transformer;
        private final String charset;
        private final String mimeType;

        private XsltBalayageTemplate(Transformer transformer) {
            String encoding;
            this.transformer = transformer;
            String method = transformer.getOutputProperty("method");
            if (method == null) {
                method = "xml";
            }
            if ((encoding = transformer.getOutputProperty("encoding")) == null) {
                encoding = "UTF-8";
            }
            this.charset = encoding;
            this.mimeType = method.equals("xml") ? "text/xml" : (method.equals("html") ? "text/html" : "text/plain");
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public String getCharset() {
            return this.charset;
        }

        @Override
        public void transform(String extractionString, OutputStream outputStream) {
            StreamSource xmlSource = new StreamSource(new StringReader(extractionString));
            try {
                this.transformer.transform(xmlSource, new StreamResult(outputStream));
            }
            catch (TransformerException te) {
                throw new NestedTransformerException(te);
            }
        }

        private Transformer getTransformer() {
            return this.transformer;
        }
    }

    private static abstract class AbstractTemplateProvider
    implements TemplateProvider {
        private final Map<String, Object> transformerParameters = new LinkedHashMap<String, Object>();
        private final Set<String> priorParamSet = new HashSet<String>();

        private AbstractTemplateProvider(BalayageOutput output) {
            boolean reversePathDone = false;
            for (BalayageOutput.Param param : output.getParamList()) {
                String name = param.getName();
                if (name.equals("BDF_REVERSEPATH")) {
                    reversePathDone = true;
                } else if (name.equals("BDF_FILENAME")) {
                    this.setFileName(param.getValue(), false);
                }
                this.setPriorParam(name, param.getValue());
            }
            if (!reversePathDone) {
                this.setPriorParam("BDF_REVERSEPATH", output.getReversePath());
            }
        }

        @Override
        public void setCurrentFileName(String fileName) {
            this.setFileName(fileName, false);
            this.setFollowingParam("BDF_FILENAME", fileName);
        }

        @Override
        public void setBalayageRoot(String balayageRoot) {
            this.setFollowingParam("BDF_BALAYAGEROOT", balayageRoot);
        }

        @Override
        public void setCurrentPath(String path) {
            if (path == null) {
                path = "";
            }
            this.setFollowingParam("BDF_PATH", path);
        }

        @Override
        public void setCurrentLang(String lang) {
            this.setFollowingParam("BDF_LANG", lang);
        }

        void initParameters(Transformer transformer) {
            for (Map.Entry<String, Object> entry : this.transformerParameters.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
        }

        private void setPriorParam(String name, String value) {
            if (value == null) {
                this.transformerParameters.remove(name);
                this.priorParamSet.remove(name);
            } else {
                this.transformerParameters.put(name, value);
                this.priorParamSet.add(name);
            }
        }

        Map<String, Object> getTransformerParameters() {
            return this.transformerParameters;
        }

        private void setFileName(String value, boolean prior) {
            String fileBaseName = null;
            String fileExtension = null;
            if (value != null) {
                fileBaseName = value;
                fileExtension = "";
                int idx = value.lastIndexOf(46);
                if (idx != -1) {
                    fileBaseName = value.substring(0, idx);
                    fileExtension = value.substring(idx + 1);
                }
            }
            if (prior) {
                this.setPriorParam("BDF_FILEBASENAME", fileBaseName);
                this.setPriorParam("BDF_FILEEXTENSION", fileExtension);
            } else {
                this.setPriorParam("BDF_FILEBASENAME", fileBaseName);
                this.setPriorParam("BDF_FILEEXTENSION", fileExtension);
            }
        }

        void setFollowingParam(String name, String value) {
            if (!this.priorParamSet.contains(name)) {
                if (value == null) {
                    this.transformerParameters.remove(name);
                } else {
                    this.transformerParameters.put(name, value);
                }
            }
        }
    }
}

