/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadataEditor;
import net.fichotheque.tools.dom.FichothequeDOMUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThesaurusDOMReader {
    private ThesaurusEditor thesaurusEditor;
    private ThesaurusMetadataEditor thesaurusMetadataEditor;
    private final MessageHandler messageHandler;

    public ThesaurusDOMReader(ThesaurusEditor thesaurusEditor, MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.thesaurusEditor = thesaurusEditor;
        this.thesaurusMetadataEditor = thesaurusEditor.getThesaurusMetadataEditor();
    }

    public void setThesaurusEditor(ThesaurusEditor thesaurusEditor) {
        this.thesaurusEditor = thesaurusEditor;
        this.thesaurusMetadataEditor = thesaurusEditor.getThesaurusMetadataEditor();
    }

    public static String getThesaurusType(Element element_xml) {
        String typeString = element_xml.getAttribute("thesaurus-type");
        return ThesaurusMetadata.checkThesaurusType(typeString);
    }

    public void fillThesaurus(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        boolean metadone = false;
        for (int i = 0; i < liste.getLength(); ++i) {
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element el = (Element)nd;
            String tagname = el.getTagName();
            if (!metadone && tagname.equals("metadata")) {
                metadone = true;
                this.fillMetadata(el);
                continue;
            }
            if (tagname.equals("motcle")) {
                this.addMotcle(el, null);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagname);
        }
    }

    private void fillMetadata(Element element_xml) {
        ThesaurusMetadata metadata = (ThesaurusMetadata)this.thesaurusMetadataEditor.getMetadata();
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        if (!metadata.getThesaurusType().equals("babelien")) {
            String langsString = element_xml.getAttribute("thesaurus-langs");
            if (langsString.length() == 0) {
                DomMessages.emptyAttribute(this.messageHandler, element_xml.getTagName(), "thesaurus-langs");
            } else {
                Langs langs = LangsUtils.toCleanLangs(langsString);
                if (langs.size() > 0) {
                    this.thesaurusMetadataEditor.setAuthorizedLangs(langs);
                } else {
                    DomMessages.wrongAttributeValue(this.messageHandler, element_xml.getTagName(), "thesaurus-langs", langsString);
                }
            }
        }
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element el = (Element)nd;
            String tagname = el.getTagName();
            if (tagname.equals("intitule")) {
                FichothequeDOMUtils.readIntitule(el, this.thesaurusMetadataEditor, this.messageHandler, "thesaurus");
                continue;
            }
            if (tagname.equals("attr")) {
                AttributeUtils.readAttrElement(attributesBuilder, el, this.messageHandler, tagname);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagname);
        }
        this.thesaurusEditor.getFichothequeEditor().putAttributes(metadata, attributesBuilder.toAttributes());
    }

    private void addMotcle(Element element_xml, Motcle parent) {
        Motcle motcle;
        int motcleid;
        String idString = element_xml.getAttribute("id");
        if (idString.length() == 0) {
            idString = element_xml.getAttribute("idths");
        }
        if (idString.length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, element_xml.getTagName(), "id");
            return;
        }
        try {
            motcleid = Integer.parseInt(idString);
        }
        catch (NumberFormatException nfe) {
            DomMessages.wrongIntegerAttributeValue(this.messageHandler, element_xml.getTagName(), "id", idString);
            return;
        }
        String idalpha = null;
        if (this.thesaurusEditor.getThesaurus().isIdalphaType() && (idalpha = element_xml.getAttribute("idalpha")).length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, element_xml.getTagName(), "idalpha");
            return;
        }
        try {
            motcle = this.thesaurusEditor.createMotcle(motcleid, idalpha);
        }
        catch (ExistingIdException eie) {
            this.messageHandler.addMessage("severe.fichotheque", "_ error.existing.idalpha", idalpha);
            return;
        }
        catch (ParseException pe) {
            DomMessages.wrongAttributeValue(this.messageHandler, element_xml.getTagName(), "idalpha", idalpha);
            return;
        }
        if (parent != null) {
            try {
                this.thesaurusEditor.setParent(motcle, parent);
            }
            catch (ParentRecursivityException pre) {
                throw new ImplementationException(pre);
            }
        }
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element el = (Element)nd;
            String tagname = el.getTagName();
            if (tagname.equals("lib")) {
                try {
                    Label label = LabelUtils.readLabel(el);
                    if (label == null) continue;
                    this.thesaurusEditor.putLabel(motcle, label);
                }
                catch (ParseException e) {
                    DomMessages.wrongLangAttribute(this.messageHandler, "lib", el.getAttribute("xml:lang"));
                }
                continue;
            }
            if (tagname.equals("motcle")) {
                this.addMotcle(el, motcle);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagname);
        }
    }
}

