/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import java.util.Collections;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.junction.JunctionChange;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.junction.Tie;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OldJunctionDOMReader {
    private final MessageHandler messageHandler;

    public OldJunctionDOMReader(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void readJunction(JunctionEditor junctionEditor, Subset subset1, Subset subset2, Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element el = (Element)nd;
            String tagname = el.getTagName();
            if (tagname.equals("ci")) {
                try {
                    InternalJunctionChange junctionChange = this.getJunctionChange(subset1, subset2, el);
                    if (junctionChange == null) continue;
                    junctionEditor.updateJunction(junctionChange.subsetItem1, junctionChange.subsetItem2, junctionChange);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagname);
        }
    }

    private InternalJunctionChange getJunctionChange(Subset subset1, Subset subset2, Element element) {
        int id1 = this.getAttribute(element, "id1", false);
        SubsetItem subsetItem1 = subset1.getSubsetItemById(id1);
        if (subsetItem1 == null) {
            return null;
        }
        int id2 = this.getAttribute(element, "id2", false);
        SubsetItem subsetItem2 = subset2.getSubsetItemById(id2);
        if (subsetItem2 == null) {
            return null;
        }
        int weight = this.getAttribute(element, "poids", true);
        if (weight == -1) {
            weight = 1;
        }
        int position1 = this.getAttribute(element, "pos1", true) + 1;
        int position2 = this.getAttribute(element, "pos2", true) + 1;
        Tie tie = JunctionUtils.toTie("", weight, position1, position2);
        return new InternalJunctionChange(subsetItem1, subsetItem2, tie);
    }

    private int getAttribute(Element element, String name, boolean emptyallowed) {
        String s = element.getAttribute(name);
        if (s.length() == 0) {
            if (emptyallowed) {
                return -1;
            }
            DomMessages.emptyAttribute(this.messageHandler, element.getTagName(), name);
            throw new IllegalArgumentException();
        }
        try {
            int entier = Integer.parseInt(s);
            if (entier < 0) {
                entier = -1;
            }
            return entier;
        }
        catch (NumberFormatException nfe) {
            DomMessages.wrongIntegerAttributeValue(this.messageHandler, element.getTagName(), name, s);
            throw new IllegalArgumentException();
        }
    }

    private static class InternalJunctionChange
    implements JunctionChange {
        private final List<Tie> tieList;
        private final SubsetItem subsetItem1;
        private final SubsetItem subsetItem2;

        private InternalJunctionChange(SubsetItem subsetItem1, SubsetItem subsetItem2, Tie lien) {
            this.tieList = Collections.singletonList(lien);
            this.subsetItem1 = subsetItem1;
            this.subsetItem2 = subsetItem2;
        }

        @Override
        public List<String> getRemovedModeList() {
            return JunctionUtils.EMPTY_REMOVEDMODELIST;
        }

        @Override
        public List<Tie> getChangedTieList() {
            return this.tieList;
        }
    }
}

