/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.BdfUserStorage;
import fr.exemole.bdfserver.api.storage.MigrationEngine;
import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.storage.directory.oldversions.AddendaDOMReader;
import fr.exemole.bdfserver.storage.directory.oldversions.ChronoDOMReader;
import fr.exemole.bdfserver.storage.directory.oldversions.ConfigurationManagerDOMReader;
import fr.exemole.bdfserver.storage.directory.oldversions.PermissionManagerDOMReader;
import fr.exemole.bdfserver.storage.directory.oldversions.PolicyManagerDOMReader;
import fr.exemole.bdfserver.storage.directory.oldversions.TreesDOMReader;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.users.BdfUserPrefsBuilder;
import fr.exemole.bdfserver.tools.users.dom.BdfUserPrefsDOMReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.UserLoginException;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DirectoryMigrationEngine
implements MigrationEngine {
    private static final AttributeKey BDFUSER_ROLES_KEY = AttributeKey.build(BdfUserSpace.BDFUSER_NAMESPACE, "roles");
    private boolean roleMigration = false;
    private final File bdfdataDir;
    private final File backupDir;

    private DirectoryMigrationEngine(File bdfdataDir, File backupDir) {
        this.bdfdataDir = bdfdataDir;
        this.backupDir = backupDir;
    }

    @Override
    public void afterInitRun(BdfServer bdfServer) {
        try (EditSession session = bdfServer.initEditSession("MigrationEngine");){
            File oldPermissionManagerFile;
            File oldPolicyManagerFile;
            File oldConfigurationManagerFile;
            File oldTreesFile;
            BdfServerEditor bdfServerEditor = session.getBdfServerEditor();
            if (this.roleMigration) {
                this.migrateRoles(bdfServer, bdfServerEditor);
            }
            if ((oldTreesFile = new File(this.bdfdataDir, "conf/ui/trees.xml")).exists()) {
                this.migrateTrees(bdfServerEditor, oldTreesFile);
                oldTreesFile.delete();
            }
            if ((oldConfigurationManagerFile = new File(this.bdfdataDir, "conf/configurationmanager.xml")).exists()) {
                this.migrateConfigurationManager(bdfServerEditor, oldConfigurationManagerFile);
                oldConfigurationManagerFile.delete();
            }
            if ((oldPolicyManagerFile = new File(this.bdfdataDir, "conf/policymanager.xml")).exists()) {
                this.migratePolicyManager(bdfServerEditor, oldPolicyManagerFile);
                oldPolicyManagerFile.delete();
            }
            if ((oldPermissionManagerFile = new File(this.bdfdataDir, "conf/permissionmanager.xml")).exists()) {
                this.migratePermissionManager(bdfServerEditor, oldPermissionManagerFile);
                oldPermissionManagerFile.delete();
            }
        }
    }

    public static DirectoryMigrationEngine init(BdfServerDirs dirs) {
        File bdfdataDir = dirs.getSubPath("var.data", "bdfdata");
        File backupDir = dirs.getSubPath("var.backup", "bdfdata");
        DirectoryMigrationEngine migrationEngine = new DirectoryMigrationEngine(bdfdataDir, backupDir);
        migrationEngine.init();
        return migrationEngine;
    }

    private void init() {
        File corpusDir;
        File confDir;
        File uiDir;
        File corpusAddendaDir;
        File addendaDir;
        String name;
        File fichothequeDir;
        File oldChronoDir;
        this.testOldFichothequeDir(this.bdfdataDir);
        this.testOldFichothequeDir(this.backupDir);
        File oldRolesDir = new File(this.bdfdataDir, "roles");
        if (oldRolesDir.exists()) {
            File confDir2 = new File(this.bdfdataDir, "conf");
            confDir2.mkdirs();
            oldRolesDir.renameTo(new File(confDir2, "roles"));
            this.roleMigration = true;
        }
        if ((oldChronoDir = new File(fichothequeDir = new File(this.bdfdataDir, "fichotheque"), "chrono")).exists()) {
            File corpusDir2 = new File(fichothequeDir, "corpus");
            ChronoDOMReader chronoDOMReader = new ChronoDOMReader();
            File[] chronoFiles = oldChronoDir.listFiles();
            int length = chronoFiles.length;
            try {
                for (int i = 0; i < length; ++i) {
                    File chronoFile = chronoFiles[i];
                    if (chronoFile.isDirectory() || !(name = chronoFile.getName()).endsWith(".xml")) continue;
                    try {
                        File currentCorpusDir;
                        SubsetKey subsetKey = SubsetKey.parse(name.substring(0, name.length() - 4));
                        if (!subsetKey.isCorpusSubset() || !(currentCorpusDir = new File(corpusDir2, subsetKey.getSubsetName())).exists()) continue;
                        Document document = DirectoryMigrationEngine.readDocument(chronoFile);
                        chronoDOMReader.migrateChrono(currentCorpusDir, document.getDocumentElement());
                        continue;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                IOUtils.deleteDirectory(oldChronoDir);
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
        if ((addendaDir = new File(fichothequeDir, "addenda")).exists()) {
            this.convertUniqueAddenda(addendaDir);
        }
        if ((corpusAddendaDir = new File(fichothequeDir, "corpus_addenda")).exists()) {
            for (File subDir : corpusAddendaDir.listFiles()) {
                name = subDir.getName();
                if (subDir.isDirectory()) {
                    if (!name.endsWith("_x")) continue;
                    subDir.renameTo(new File(corpusAddendaDir, name.substring(0, name.length() - 2) + "_doc"));
                    continue;
                }
                if (!name.endsWith("_x.xml")) continue;
                subDir.renameTo(new File(corpusAddendaDir, name.substring(0, name.length() - 6) + "_doc.xml"));
            }
        }
        if ((uiDir = new File(confDir = new File(this.bdfdataDir, "conf"), "ui")).exists() && !(corpusDir = new File(uiDir, "corpus")).exists()) {
            corpusDir.mkdirs();
            for (File file : uiDir.listFiles()) {
                String name2 = file.getName();
                if (file.isDirectory() || !name2.endsWith(".xml")) continue;
                try {
                    SubsetKey subsetKey = SubsetKey.parse(name2.substring(0, name2.length() - 4));
                    if (!subsetKey.isCorpusSubset()) continue;
                    File subsetDir = new File(corpusDir, subsetKey.getSubsetName());
                    subsetDir.mkdir();
                    file.renameTo(new File(subsetDir, "_main.xml"));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private void testOldFichothequeDir(File rootDir) {
        if (rootDir == null) {
            return;
        }
        File oldFichothequeDir = new File(rootDir, "basedefiches");
        if (oldFichothequeDir.exists()) {
            File newFichothequeDir = new File(rootDir, "fichotheque");
            newFichothequeDir.mkdirs();
            oldFichothequeDir.renameTo(newFichothequeDir);
        }
    }

    private void convertUniqueAddenda(File addendaDir) {
        File xDir = new File(addendaDir, "x");
        if (!xDir.exists()) {
            return;
        }
        File docFile = new File(addendaDir, "doc.xml");
        if (docFile.exists()) {
            return;
        }
        File docDir = new File(addendaDir, "doc");
        if (docDir.exists()) {
            return;
        }
        File xFile = new File(addendaDir, "x.xml");
        if (xFile.exists()) {
            Document document = DOMUtils.readDocument(xFile);
            Element rootElement = document.getDocumentElement();
            if (!rootElement.getTagName().equals("addenda-metadata")) {
                Map<Integer, String> nameMap = AddendaDOMReader.getNameMap(rootElement);
                for (Map.Entry<Integer, String> entry : nameMap.entrySet()) {
                    File documentFile;
                    int documentid = entry.getKey();
                    File documentDir = new File(xDir, "d." + BdfServerUtils.getMillier(documentid) + File.separatorChar + documentid);
                    if (!documentDir.exists() || (documentFile = new File(documentDir, "document.xml")).exists()) continue;
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(documentFile), "UTF-8");){
                        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<document basename=\"" + entry.getValue() + "\"/>");
                    }
                    catch (IOException ioe) {
                        throw new BdfStorageException(ioe);
                    }
                }
            }
            xFile.delete();
        }
        try (InputStream is = this.getClass().getResourceAsStream("doc.xml");
             FileOutputStream os = new FileOutputStream(docFile);){
            IOUtils.copy(is, (OutputStream)os);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
        xDir.renameTo(docDir);
    }

    private void migrateRoles(BdfServer bdfServer, BdfServerEditor bdfServerEditor) {
        File userDir = new File(this.bdfdataDir, "users");
        if (!userDir.exists()) {
            return;
        }
        Fichotheque fichotheque = bdfServer.getFichotheque();
        FichothequeQuestioner fichothequeQuestioner = bdfServer.getFichothequeQuestioner();
        BdfUserStorage userStorage = bdfServer.getBdfUserStorage();
        PermissionManager permissionManager = bdfServer.getPermissionManager();
        for (File f : userDir.listFiles()) {
            String fileName;
            if (f.isDirectory() || !(fileName = f.getName()).endsWith(".xml")) continue;
            String redacteurKeyString = fileName.substring(0, fileName.length() - 4);
            try {
                Redacteur redacteur = fichothequeQuestioner.getRedacteurByLogin(redacteurKeyString);
                Document doc = DirectoryMigrationEngine.readDocument(f);
                BdfUserPrefsBuilder userPrefsBuilder = new BdfUserPrefsBuilder();
                BdfUserPrefsDOMReader domReader = new BdfUserPrefsDOMReader(fichotheque, userPrefsBuilder);
                domReader.readBdfUserPrefs(doc.getDocumentElement());
                BdfUserPrefs userPrefs = userPrefsBuilder.toBdfUserPrefs();
                Attributes userPrefsAttributes = userPrefs.getAttributes();
                Attribute oldRoleAttribute = userPrefsAttributes.getAttribute(BDFUSER_ROLES_KEY);
                if (oldRoleAttribute != null) {
                    for (String roleName : oldRoleAttribute) {
                        Role role = permissionManager.getRole(roleName);
                        if (role == null) continue;
                        bdfServerEditor.link(redacteur, role);
                    }
                    userPrefsBuilder = BdfUserPrefsBuilder.init().setDefaultFicheQuery(userPrefs.getDefaultFicheQuery()).setWorkingLang(userPrefs.getWorkingLang()).setCustomFormatLocale(userPrefs.getCustomFormatLocale()).setCustomLangPreference(userPrefs.getCustomLangPreference());
                    for (Attribute otherAttribute : userPrefsAttributes) {
                        if (otherAttribute.getAttributeKey().equals(BDFUSER_ROLES_KEY)) continue;
                        userPrefsBuilder.getAttributesBuilder().appendValues(otherAttribute);
                    }
                    userPrefs = userPrefsBuilder.toBdfUserPrefs();
                }
                userStorage.saveBdfUserPrefs(redacteur, userPrefs);
                f.delete();
            }
            catch (UserLoginException e) {
                if (e.isMalformedKey()) continue;
                f.delete();
            }
        }
    }

    private void migrateTrees(BdfServerEditor bdfServerEditor, File file) {
        Document doc = DirectoryMigrationEngine.readDocument(file);
        TreesDOMReader treesDOMReader = new TreesDOMReader(LogUtils.NULL_MESSAGEHANDLER);
        treesDOMReader.readTrees(bdfServerEditor, doc.getDocumentElement());
    }

    private void migrateConfigurationManager(BdfServerEditor bdfServerEditor, File file) {
        Document doc = DirectoryMigrationEngine.readDocument(file);
        ConfigurationManagerDOMReader configurationManagerDOMReader = new ConfigurationManagerDOMReader(LogUtils.NULL_MESSAGEHANDLER);
        configurationManagerDOMReader.readConfigurationManager(bdfServerEditor, doc.getDocumentElement());
    }

    private void migratePolicyManager(BdfServerEditor bdfServerEditor, File file) {
        Document doc = DirectoryMigrationEngine.readDocument(file);
        PolicyManagerDOMReader policyManagerDOMReader = new PolicyManagerDOMReader(bdfServerEditor, LogUtils.NULL_MESSAGEHANDLER);
        policyManagerDOMReader.readPolicyManager(doc.getDocumentElement());
    }

    private void migratePermissionManager(BdfServerEditor bdfServerEditor, File file) {
        Document doc = DirectoryMigrationEngine.readDocument(file);
        PermissionManagerDOMReader policyManagerDOMReader = new PermissionManagerDOMReader(LogUtils.NULL_MESSAGEHANDLER);
        policyManagerDOMReader.readPermissionManager(bdfServerEditor, doc.getDocumentElement());
    }

    private static Document readDocument(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docbuilder = null;
        Document document = null;
        try {
            docbuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new BdfStorageException(pce);
        }
        try (FileInputStream is = new FileInputStream(file);){
            document = docbuilder.parse(is);
        }
        catch (IOException | SAXException e) {
            throw new BdfStorageException(file, (Throwable)e);
        }
        return document;
    }
}

