/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.policies.UserAllow;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.PolicyStorage;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.policies.UserAllowBuilder;
import fr.exemole.bdfserver.tools.policies.dom.ThesaurusPolicyDOMReader;
import fr.exemole.bdfserver.tools.policies.dom.UserAllowDOMReader;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import fr.exemole.bdfserver.xml.policies.ThesaurusPolicyXMLPart;
import fr.exemole.bdfserver.xml.policies.UserAllowXMLPart;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;

public class PolicyStorageImpl
implements PolicyStorage {
    private final StorageDirectory bdfdataDirectory;
    private final String rootPath = "conf" + File.separator + "policies";

    public PolicyStorageImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    @Override
    public void saveUserAllow(UserAllow userAllow) {
        StorageFile storageFile = this.getUserAllowFile();
        try (BufferedWriter buf = storageFile.getWriter();){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            UserAllowXMLPart xmlPart = new UserAllowXMLPart(xmlWriter);
            xmlPart.addUserAllow(userAllow);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    @Override
    public void saveSubsetPolicy(SubsetKey subsetKey, Object policyObject) {
        if (!subsetKey.isThesaurusSubset() || policyObject == null) {
            this.removeSubsetPolicy(subsetKey);
            return;
        }
        if (!(policyObject instanceof DynamicEditPolicy)) {
            throw new IllegalArgumentException("policyObject is not instance of DynamicEditPolicy");
        }
        StorageFile storageFile = this.getSubsetPolicyFile(subsetKey);
        try (BufferedWriter buf = storageFile.getWriter();){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            ThesaurusPolicyXMLPart thesaurusPolicyXMLPart = new ThesaurusPolicyXMLPart(xmlWriter);
            thesaurusPolicyXMLPart.addThesaurusPolicy(subsetKey, (DynamicEditPolicy)policyObject);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    @Override
    public void removeSubsetPolicy(SubsetKey subsetKey) {
        StorageFile storageFile = this.getSubsetPolicyFile(subsetKey);
        if (storageFile.exists()) {
            storageFile.delete();
        }
    }

    public UserAllow checkUserAllow(MultiMessageHandler messageHandler) {
        UserAllowBuilder builder = new UserAllowBuilder();
        StorageFile storageFile = this.getUserAllowFile();
        if (storageFile.exists()) {
            messageHandler.setCurrentSource(storageFile.toURI());
            Document doc = storageFile.readDocument();
            UserAllowDOMReader userAllowDOMReader = new UserAllowDOMReader(builder, messageHandler);
            userAllowDOMReader.readUserAllow(doc.getDocumentElement());
        }
        return builder.toUserAllow();
    }

    public Map<SubsetKey, Object> checkSubsetPolicyMap(MultiMessageHandler messageHandler, Fichotheque fichotheque) {
        HashMap<SubsetKey, Object> result = new HashMap<SubsetKey, Object>();
        File treesDirectory = this.bdfdataDirectory.getDataDir(this.rootPath);
        if (!treesDirectory.exists()) {
            return result;
        }
        ThesaurusPolicyDOMReader domReader = new ThesaurusPolicyDOMReader(messageHandler, fichotheque);
        for (File f : treesDirectory.listFiles()) {
            String fileName;
            if (f.isDirectory() || !(fileName = f.getName()).endsWith(".xml")) continue;
            try {
                SubsetKey subsetKey = SubsetKey.parse(fileName.substring(0, fileName.length() - 4));
                if (!subsetKey.isThesaurusSubset()) continue;
                StorageFile storageFile = this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + fileName);
                messageHandler.setCurrentSource(storageFile.toURI());
                Document doc = storageFile.readDocument();
                DynamicEditPolicy policy = domReader.readDynamicEditPolicy(doc.getDocumentElement(), subsetKey);
                if (policy == null) continue;
                result.put(subsetKey, policy);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    private StorageFile getUserAllowFile() {
        return this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + "user-allow.xml");
    }

    private StorageFile getSubsetPolicyFile(SubsetKey subsetKey) {
        return this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + subsetKey + ".xml");
    }
}

