/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.storage.BdfExtensionStorage;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import java.io.File;

public class BdfExtensionStorageImpl
implements BdfExtensionStorage {
    private static final String SUBDIR = "extdata";
    private final File varDirectory;
    private final File backupDirectory;

    public BdfExtensionStorageImpl(BdfServerDirs dirs) {
        this.varDirectory = dirs.getSubPath("var.data", SUBDIR);
        this.backupDirectory = dirs.getSubPath("var.backup", SUBDIR);
    }

    @Override
    public File getDataDirectory(String extensionName) {
        File dir = new File(this.varDirectory, extensionName);
        if (dir.exists() && !dir.isDirectory()) {
            throw new BdfStorageException(dir.getAbsolutePath() + " is not a directory");
        }
        return dir;
    }

    @Override
    public File getBackupDirectory(String extensionName) {
        if (this.backupDirectory == null) {
            return null;
        }
        File dir = new File(this.backupDirectory, extensionName);
        if (dir.exists() && !dir.isDirectory()) {
            throw new BdfStorageException(dir.getAbsolutePath() + " is not a directory");
        }
        return dir;
    }
}

