/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.tools;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.tools.FichothequeInfo;
import fr.exemole.bdfserver.storage.directory.tools.SphereChecker;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.sphere.LoginKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;

public class PresenceInfo
extends FichothequeInfo {
    public static final String NO_SPHERE = "nosphere";
    public static final String NO_USER = "nouser";
    public static final String HERE = "here";
    public static final String INACTIVE = "inactive";
    public static final String READONLY = "readonly";
    public static final String USER = "user";
    public static final String ADMIN = "admin";
    private final String level;
    private final Redacteur redacteur;

    public PresenceInfo(String name, BdfServer bdfServer, String level, Redacteur redacteur) {
        super(name, bdfServer);
        this.level = level;
        this.redacteur = redacteur;
    }

    public PresenceInfo(String name, BdfServerDirs bdfServerDirs, String level) {
        super(name, bdfServerDirs);
        this.level = level;
        this.redacteur = null;
    }

    public String getLevel() {
        return this.level;
    }

    public Redacteur getRedacteur() {
        return this.redacteur;
    }

    public static List<PresenceInfo> scan(Multi multi, CentralUser centralUser, boolean all) {
        ArrayList<PresenceInfo> list = new ArrayList<PresenceInfo>();
        LoginKey loginKey = centralUser.getLoginKey();
        for (String name : multi.getExistingNameSet()) {
            BdfServer bdfServer = multi.getInitBdfServer(name);
            PresenceInfo presenceInfo = bdfServer != null ? PresenceInfo.getPresenceInfo(name, bdfServer, loginKey, all) : PresenceInfo.getPresenceInfo(name, multi.getBdfServerDirs(name), loginKey, all);
            if (presenceInfo == null) continue;
            list.add(presenceInfo);
        }
        return list;
    }

    private static PresenceInfo getPresenceInfo(String name, BdfServer bdfServer, LoginKey loginKey, boolean all) {
        String level = null;
        Sphere sphere = (Sphere)bdfServer.getFichotheque().getSubset(loginKey.getSphereKey());
        Redacteur redacteur = null;
        if (sphere != null) {
            redacteur = sphere.getRedacteurByLogin(loginKey.getLogin());
            if (redacteur == null) {
                level = NO_USER;
            }
        } else {
            level = NO_SPHERE;
        }
        if (redacteur != null) {
            switch (redacteur.getStatus()) {
                case "inactive": {
                    level = INACTIVE;
                    break;
                }
                case "readonly": {
                    level = READONLY;
                    break;
                }
                default: {
                    PermissionManager permissionManager = bdfServer.getPermissionManager();
                    level = permissionManager.isAdmin(redacteur) ? ADMIN : USER;
                }
            }
        }
        if (!all) {
            switch (level) {
                case "nouser": 
                case "inactive": {
                    return null;
                }
            }
        }
        return new PresenceInfo(name, bdfServer, level, redacteur);
    }

    private static PresenceInfo getPresenceInfo(String name, BdfServerDirs bdfServerDirs, LoginKey loginKey, boolean all) {
        String level = !SphereChecker.containsSphere(loginKey.getSphereKey(), bdfServerDirs) ? NO_SPHERE : (SphereChecker.containsRedacteur(loginKey, bdfServerDirs) ? HERE : NO_USER);
        if (!all && !level.equals(HERE)) {
            return null;
        }
        return new PresenceInfo(name, bdfServerDirs, level);
    }
}

