/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.htmlproducers;

import fr.exemole.bdfserver.html.AppInit;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.htmlproducers.MultiHtmlProducer;
import fr.exemole.bdfserver.multi.json.CentralUserJson;
import fr.exemole.bdfserver.tools.apps.AppConf;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.html.TrustedHtml;
import net.mapeadores.util.html.jsoup.HtmlCleaners;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.RelativePath;

public class AppHtmlProducer
extends MultiHtmlProducer {
    private final AppConf appConf;
    private final CentralUser centralUser;

    public AppHtmlProducer(Multi multi, AppConf appConf) {
        super(multi, (Lang)multi.getMultiMetadata().getWorkingLangs().get(0));
        this.appConf = appConf;
        this.centralUser = null;
        AppInit.init(this, appConf, multi.getWebappsResourceStorages(), null);
    }

    public AppHtmlProducer(Multi multi, AppConf appConf, CentralUser centralUser) {
        super(multi, centralUser.getUserLangContext().getLangPreference());
        this.appConf = appConf;
        this.centralUser = centralUser;
        AppInit.init(this, appConf, multi.getWebappsResourceStorages(), null);
    }

    @Override
    public void printHtml() {
        JsObject jsObject;
        this.start(this.getTitle(this.appConf.getAppName()));
        RelativePath appHtmlPath = StorageUtils.buildAppResourcePath(this.appConf.getAppName(), "app.html");
        DocStream docStream = this.multi.getWebappsResourceStorages().getResourceDocStream(appHtmlPath);
        if (docStream != null) {
            String appHtml = docStream.getContent();
            TrustedHtml trustedHtml = HtmlCleaners.WELLFORMED.cleanHtml(appHtml);
            this.__append(trustedHtml);
        }
        if ((jsObject = this.appConf.getArgsJsObject()) != null) {
            this.SCRIPT().__jsObject("ARGS", jsObject)._SCRIPT();
        }
        if (this.centralUser != null) {
            JsObject centralUserJsObject = new JsObject();
            CentralUserJson.populate(centralUserJsObject, this.centralUser);
            this.SCRIPT().__jsObject("CENTRALUSER", centralUserJsObject).__jsObject("BDFUSER", centralUserJsObject)._SCRIPT();
        }
        this.end();
    }
}

