/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.api.central.CentralUserEditor;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.security.PasswordChecker;
import net.mapeadores.util.text.StringUtils;

public class CentralUserCreationCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "CentralUserCreation";
    public static final String NEWLOGIN_PARAMNAME = "newlogin";
    public static final String SURNAME_PARAMNAME = "surname";
    public static final String NONLATIN_PARAMNAME = "nonlatin";
    public static final String FORENAME_PARAMNAME = "forename";
    public static final String SURNAMEFIRST_PARAMNAME = "surnamefirst";
    public static final String EMAIL_PARAMNAME = "email";
    public static final String PASSWORD1_PARAMNAME = "password1";
    public static final String PASSWORD2_PARAMNAME = "password2";

    public CentralUserCreationCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        this.initCentralSphere();
        String newlogin = this.getLogin();
        PersonCore person = this.getPerson();
        EmailCore email = this.getEmail();
        String password = this.getPassword();
        String encryptedPassword = PasswordChecker.getHash("pbkdf2", password);
        this.initCentralEditors();
        CentralSphere centralSphere = this.getCentralSphere();
        synchronized (centralSphere) {
            CentralUserEditor centralUserEditor = this.centralSphereEditor.createCentralUser(newlogin);
            centralUserEditor.setPerson(person);
            centralUserEditor.setEmail(email);
            centralUserEditor.setEncryptedPassword(encryptedPassword);
            centralUserEditor.setLangContext((Lang)this.multi.getMultiMetadata().getWorkingLangs().get(0), null, null);
            this.saveChanges();
        }
        return this.done("_ done.sphere.redacteurcreation", newlogin);
    }

    private String getLogin() throws ErrorMessageException {
        String newlogin = this.getMandatory(NEWLOGIN_PARAMNAME);
        if ((newlogin = newlogin.trim()).length() == 0) {
            throw BdfErrors.error("_ error.empty.login", newlogin);
        }
        if (!SphereUtils.testLogin(newlogin)) {
            throw BdfErrors.error("_ error.wrong.login", newlogin);
        }
        if (this.centralSphere.hasCentralUser(newlogin)) {
            throw BdfErrors.error("_ error.existing.login", newlogin);
        }
        return newlogin;
    }

    private PersonCore getPerson() throws ErrorMessageException {
        String nonlatin;
        String surname = this.getMandatory(SURNAME_PARAMNAME);
        surname = StringUtils.cleanString(surname);
        String forename = StringUtils.cleanString(this.requestMap.getParameter(FORENAME_PARAMNAME));
        if (forename == null) {
            forename = "";
        }
        if ((nonlatin = StringUtils.cleanString(this.requestMap.getParameter(NONLATIN_PARAMNAME))) == null) {
            nonlatin = "";
        }
        boolean surnameFirst = this.requestMap.isTrue(SURNAMEFIRST_PARAMNAME);
        return PersonCoreUtils.toPersonCore(surname, forename, nonlatin, surnameFirst);
    }

    private EmailCore getEmail() throws ErrorMessageException {
        String email = StringUtils.cleanString(this.requestMap.getParameter(EMAIL_PARAMNAME));
        if (email == null || email.length() == 0) {
            return null;
        }
        try {
            return EmailCoreUtils.parse(email);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.email", email);
        }
    }

    private String getPassword() throws ErrorMessageException {
        String mdp2;
        String mdp1 = this.getMandatory(PASSWORD1_PARAMNAME);
        if (!mdp1.equals(mdp2 = this.getMandatory(PASSWORD2_PARAMNAME))) {
            throw BdfErrors.error("_ error.wrong.password_different");
        }
        String password = mdp1;
        if (password.length() == 0) {
            throw BdfErrors.error("_ error.empty.password");
        }
        if (password.length() < 4) {
            throw BdfErrors.error("_ error.wrong.password_tooshort");
        }
        return password;
    }
}

