/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.multi.tools.PresenceInfo;
import java.util.List;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class CentralPersonChangeCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "CentralPersonChange";
    public static final String SURNAME_PARAMNAME = "surname";
    public static final String NONLATIN_PARAMNAME = "nonlatin";
    public static final String FORENAME_PARAMNAME = "forename";
    public static final String SURNAMEFIRST_PARAMNAME = "surnamefirst";

    public CentralPersonChangeCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        boolean done;
        this.initCentralSphere();
        this.initCentralUser();
        PersonCore newPerson = this.getPerson();
        this.initCentralEditors();
        CentralSphere centralSphere = this.getCentralSphere();
        synchronized (centralSphere) {
            done = this.getCentralUserEditor().setPerson(newPerson);
            this.saveChanges();
        }
        if (done) {
            List<PresenceInfo> presenceInfoList = PresenceInfo.scan(this.multi, this.centralUser, false);
            for (PresenceInfo presenceInfo : presenceInfoList) {
                BdfServer currentBdfServer;
                Redacteur redacteur = presenceInfo.getRedacteur();
                if (redacteur == null) continue;
                BdfServer bdfServer = currentBdfServer = presenceInfo.getBdfServer();
                synchronized (bdfServer) {
                    try (EditSession editSession = this.newEditSession(currentBdfServer, COMMAND_NAME);){
                        SphereEditor sphereEditor = editSession.getFichothequeEditor().getSphereEditor(redacteur.getSubsetKey());
                        sphereEditor.setPerson(redacteur, newPerson);
                    }
                }
            }
        }
        if (done) {
            return this.done("_ done.sphere.redacteurchange");
        }
        return null;
    }

    private PersonCore getPerson() throws ErrorMessageException {
        String nonlatin;
        String surname = this.getMandatory(SURNAME_PARAMNAME);
        surname = StringUtils.cleanString(surname);
        String forename = StringUtils.cleanString(this.requestMap.getParameter(FORENAME_PARAMNAME));
        if (forename == null) {
            forename = "";
        }
        if ((nonlatin = StringUtils.cleanString(this.requestMap.getParameter(NONLATIN_PARAMNAME))) == null) {
            nonlatin = "";
        }
        boolean surnameFirst = this.requestMap.isTrue(SURNAMEFIRST_PARAMNAME);
        return PersonCoreUtils.toPersonCore(surname, forename, nonlatin, surnameFirst);
    }
}

