/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.security.PasswordChecker;

public class MultiConf {
    public static final String MISSING_FILE_ERROR = "_ error.empty.inifile";
    public static final String LOGIN_PARAM = "login";
    public static final String PASSWORD_PARAM = "password";
    public static final String LANG_PARAM = "lang";
    public static final String AUTHORITY_PARAM = "authority";
    public static final String DEFAULT_FICHOTHEQUE_PARAM = "default_fichotheque";
    public static final short CONNECTED_STATE = 1;
    public static final short AUTHREQUIRED_STATE = 2;
    public static final short AUTHFAILED_STATE = 3;
    private final File iniFile;
    private final Map<String, String> confMap = new HashMap<String, String>();
    private CommandMessage initErrorMessage;
    private String login;
    private String passwordHash;

    private MultiConf(File iniFile) {
        this.iniFile = iniFile;
    }

    public void update() {
        if (this.iniFile.exists()) {
            this.confMap.clear();
            HashMap<String, String> map = new HashMap<String, String>();
            try (FileInputStream is = new FileInputStream(this.iniFile);){
                IniParser.parseIni((InputStream)is, map);
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
            this.login = null;
            this.passwordHash = null;
            this.initErrorMessage = null;
            block17: for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                String value = ((String)entry.getValue()).trim();
                switch ((String)entry.getKey()) {
                    case "login": {
                        if (value.isEmpty()) continue block17;
                        this.login = value;
                        continue block17;
                    }
                    case "password": {
                        if (value.isEmpty()) continue block17;
                        this.passwordHash = value;
                        continue block17;
                    }
                    case "uuid": {
                        this.confMap.put(AUTHORITY_PARAM, value);
                        continue block17;
                    }
                }
                this.confMap.put(key, value);
            }
            if (this.login == null) {
                this.initErrorMessage = LogUtils.error("_ error.empty.mandatoryparameter", LOGIN_PARAM);
            } else if (this.passwordHash == null) {
                this.initErrorMessage = LogUtils.error("_ error.empty.mandatoryparameter", PASSWORD_PARAM);
            } else {
                this.passwordHash = MultiConf.checkPasswordHash(this.passwordHash, this.iniFile);
            }
        } else {
            this.initErrorMessage = LogUtils.error(MISSING_FILE_ERROR, this.iniFile.getName());
        }
    }

    public File getInitFile() {
        return this.iniFile;
    }

    public CommandMessage getInitErrorMessage() {
        return this.initErrorMessage;
    }

    public String getParam(String name) {
        return this.confMap.get(name);
    }

    public short checkAuthentification(RequestMap requestMap, boolean passwordDisabled) {
        if (this.initErrorMessage != null) {
            throw new IllegalStateException("multiAdmin has init error");
        }
        String loginValue = requestMap.getParameter(LOGIN_PARAM);
        if (loginValue == null) {
            return 2;
        }
        if (!loginValue.equals(this.login)) {
            return 3;
        }
        if (!passwordDisabled) {
            String passwordValue = requestMap.getParameter(PASSWORD_PARAM);
            if (passwordValue == null) {
                return 2;
            }
            if (!PasswordChecker.check(passwordValue, this.passwordHash)) {
                return 3;
            }
        }
        return 1;
    }

    private static String checkPasswordHash(String passwordHash, File iniFile) {
        String mode = PasswordChecker.getHashMode(passwordHash);
        if (!mode.equals("clear")) {
            return passwordHash;
        }
        String newHash = PasswordChecker.getHash("pbkdf2", passwordHash.substring("clear".length() + 1));
        try {
            String iniString = FileUtils.readFileToString(iniFile, "UTF-8");
            iniString = iniString.replace(passwordHash, newHash);
            FileUtils.writeStringToFile(iniFile, iniString, "UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return newHash;
    }

    public static MultiConf build(File iniFile) {
        MultiConf multiConf = new MultiConf(iniFile);
        multiConf.update();
        return multiConf;
    }
}

