/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.json.HistoryJson;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.fichotheque.history.FicheHistory;
import net.fichotheque.history.HistoryUnit;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProperty;

public class LastRevisionsProperty
implements JsonProperty {
    private final BdfServer bdfServer;
    private final Collection<FicheHistory> ficheHistories;

    public LastRevisionsProperty(BdfServer bdfServer, Collection<FicheHistory> ficheHistories) {
        this.bdfServer = bdfServer;
        this.ficheHistories = ficheHistories;
    }

    @Override
    public String getName() {
        return "lastRevisions";
    }

    @Override
    public void writeValue(JSONWriter jw) throws IOException {
        LinkedHashSet<String> globalIdSet = new LinkedHashSet<String>();
        jw.object();
        jw.key("array");
        jw.array();
        for (FicheHistory ficheHistory : this.ficheHistories) {
            HistoryUnit ficheUnit = ficheHistory.getFicheUnit();
            jw.object();
            jw.key("corpus").value(ficheHistory.getCorpusKey().getSubsetName());
            jw.key("id").value(ficheHistory.getId());
            if (!ficheUnit.isEmpty()) {
                jw.key("lastRevision");
                jw.object();
                HistoryJson.properties(jw, ficheUnit.getMostRecentRevision(), globalIdSet);
                jw.endObject();
            }
            jw.endObject();
        }
        jw.endArray();
        HistoryJson.userMapProperty(jw, this.bdfServer.getFichothequeQuestioner(), globalIdSet);
        jw.endObject();
    }
}

