/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.json;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.json.CorpusFieldJson;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.subsettree.TreeFilterEngine;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.io.IOException;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.text.Label;

public final class SubsetTreeJson {
    private SubsetTreeJson() {
    }

    public static void properties(JSONWriter jw, Parameters parameters, short subsetCategory) throws IOException {
        SubsetTree subsetTree = parameters.getBdfServer().getTreeManager().getSubsetTree(subsetCategory);
        PermissionSummary permissionSummary = parameters.getPermissionSummary();
        if (permissionSummary != null) {
            subsetTree = TreeFilterEngine.read(permissionSummary, subsetTree);
        }
        jw.key(SubsetKey.categoryToString(subsetCategory));
        SubsetTreeJson.nodeArray(jw, parameters, subsetTree);
    }

    public static void nodeArray(JSONWriter jw, Parameters parameters, SubsetTree subsetTree) throws IOException {
        jw.array();
        for (SubsetTree.Node node : subsetTree.getNodeList()) {
            if (node instanceof SubsetNode) {
                SubsetTreeJson.writeSubsetNode(jw, parameters, (SubsetNode)node);
                continue;
            }
            if (!(node instanceof GroupNode)) continue;
            SubsetTreeJson.writeGroupNode(jw, parameters, (GroupNode)node);
        }
        jw.endArray();
    }

    public static Parameters initParameters(BdfServer bdfServer, Lang lang, MessageLocalisation messageLocalisation) {
        return new Parameters(bdfServer, lang, messageLocalisation);
    }

    private static void writeGroupNode(JSONWriter jw, Parameters parameters, GroupNode groupNode) throws IOException {
        jw.object();
        jw.key("node").value("group");
        jw.key("name").value(groupNode.getName());
        jw.key("title").value(TreeUtils.getTitle(parameters.getBdfServer(), groupNode, parameters.getLang()));
        jw.key("array");
        jw.array();
        for (SubsetTree.Node subnode : groupNode.getSubnodeList()) {
            if (subnode instanceof SubsetNode) {
                SubsetTreeJson.writeSubsetNode(jw, parameters, (SubsetNode)subnode);
                continue;
            }
            if (!(subnode instanceof GroupNode)) continue;
            SubsetTreeJson.writeGroupNode(jw, parameters, (GroupNode)subnode);
        }
        jw.endArray();
        jw.endObject();
    }

    private static void writeSubsetNode(JSONWriter jw, Parameters parameters, SubsetNode subsetNode) throws IOException {
        Subset masterSubset;
        SubsetKey subsetKey;
        Fichotheque fichotheque = parameters.getBdfServer().getFichotheque();
        Subset subset = fichotheque.getSubset(subsetKey = subsetNode.getSubsetKey());
        if (subset == null) {
            return;
        }
        jw.object();
        jw.key("node").value("subset");
        jw.key("key").value(subsetKey.getKeyString());
        jw.key("name").value(subsetKey.getSubsetName());
        Label titleLabel = FichothequeUtils.getTitleLabel(subset, parameters.getLang());
        if (titleLabel != null) {
            jw.key("title").value(titleLabel.getLabelString());
        }
        if (subset instanceof Corpus && (masterSubset = ((Corpus)subset).getMasterSubset()) != null) {
            SubsetKey masterSubsetKey = masterSubset.getSubsetKey();
            jw.key("master");
            jw.object();
            jw.key("category").value(masterSubsetKey.getCategoryString());
            jw.key("name").value(masterSubsetKey.getSubsetName());
            if (masterSubset instanceof Thesaurus && ((Thesaurus)masterSubset).isIdalphaType()) {
                jw.key("type").value("idalpha");
            }
            jw.endObject();
        }
        if (parameters.isWithDetails()) {
            jw.key("details");
            jw.object();
            if (subset instanceof Corpus) {
                SubsetTreeJson.writeCorpusDetails(jw, parameters, (Corpus)subset);
            }
            if (subset instanceof Thesaurus) {
                SubsetTreeJson.writeThesaurusDetails(jw, parameters, (Thesaurus)subset);
            }
            jw.endObject();
        }
        jw.endObject();
    }

    private static void writeCorpusDetails(JSONWriter jw, Parameters parameters, Corpus corpus) throws IOException {
        BdfServer bdfServer = parameters.getBdfServer();
        Lang lang = parameters.getLang();
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        jw.key("ui");
        jw.array();
        UiComponents uiComponents = bdfServer.getUiManager().getMainUiComponents(corpus);
        boolean dateCreationDone = false;
        boolean dateModificationDone = false;
        for (UiComponent uiComponent : uiComponents.getUiComponentList()) {
            if (uiComponent instanceof FieldUi) {
                FieldUi fieldUi = (FieldUi)uiComponent;
                CorpusField corpusField = corpusMetadata.getCorpusField(fieldUi.getFieldKey());
                if (corpusField == null) continue;
                SubsetTreeJson.writeCorpusField(jw, parameters, corpusField);
                continue;
            }
            if (!(uiComponent instanceof IncludeUi)) continue;
            IncludeUi includeUi = (IncludeUi)uiComponent;
            String label = L10nUtils.getIncludeTitle(bdfServer, includeUi, lang);
            if (label == null) {
                label = includeUi.getName();
            }
            SubsetTreeJson.writeCorpusInclude(jw, parameters, includeUi, label);
            switch (includeUi.getName()) {
                case "date_creation": {
                    dateCreationDone = true;
                    break;
                }
                case "date_modification": {
                    dateModificationDone = true;
                }
            }
        }
        jw.endArray();
        jw.key("misc");
        jw.array();
        CorpusField idCorpusField = corpusMetadata.getCorpusField(FieldKey.ID);
        SubsetTreeJson.writeCorpusField(jw, parameters, idCorpusField);
        if (!dateCreationDone) {
            SubsetTreeJson.writeCorpusInclude(jw, parameters, "date_creation");
        }
        if (!dateModificationDone) {
            SubsetTreeJson.writeCorpusInclude(jw, parameters, "date_modification");
        }
        jw.endArray();
        Subset masterSubset = corpus.getMasterSubset();
        List<Corpus> satelliteCorpusList = corpus.getSatelliteCorpusList();
        if (masterSubset != null || !satelliteCorpusList.isEmpty()) {
            jw.key("parentage");
            jw.array();
            if (masterSubset != null) {
                SubsetTreeJson.writeParentageDetail(jw, parameters, masterSubset);
                satelliteCorpusList = masterSubset.getSatelliteCorpusList();
            }
            for (Corpus other : satelliteCorpusList) {
                if (other.equals(corpus)) continue;
                SubsetTreeJson.writeParentageDetail(jw, parameters, other);
            }
            jw.endArray();
        }
    }

    private static void writeThesaurusDetails(JSONWriter jw, Parameters parameters, Thesaurus thesaurus) throws IOException {
        BdfServer bdfServer = parameters.getBdfServer();
        Lang lang = parameters.getLang();
        List<ThesaurusFieldKey> coreList = ThesaurusUtils.computeCoreFieldList(thesaurus, bdfServer.getThesaurusLangChecker());
        List<Corpus> satelliteCorpusList = thesaurus.getSatelliteCorpusList();
        jw.key("core");
        jw.array();
        for (ThesaurusFieldKey thesaurusFieldKey : coreList) {
            SubsetTreeJson.writeThesaurusFieldKey(jw, parameters, thesaurus, thesaurusFieldKey);
        }
        jw.endArray();
        jw.key("supp");
        jw.array();
        SubsetTreeJson.writeThesaurusFieldKey(jw, parameters, thesaurus, ThesaurusFieldKey.LEVEL);
        SubsetTreeJson.writeThesaurusFieldKey(jw, parameters, thesaurus, ThesaurusFieldKey.POSITION_LOCAL);
        SubsetTreeJson.writeThesaurusFieldKey(jw, parameters, thesaurus, ThesaurusFieldKey.POSITION_GLOBAL);
        SubsetTreeJson.writeThesaurusFieldKey(jw, parameters, thesaurus, ThesaurusFieldKey.THIS);
        if (!satelliteCorpusList.isEmpty()) {
            String title = L10nUtils.getSpecialIncludeTitle(bdfServer, "parentage", lang);
            if (title == null) {
                title = "parentage";
            }
            jw.object();
            jw.key("key").value("parentage");
            jw.key("patternType").value("fiche");
            jw.key("title").value(title);
            jw.endObject();
        }
        jw.endArray();
        if (!satelliteCorpusList.isEmpty()) {
            jw.key("parentage");
            jw.array();
            for (Corpus corpus : satelliteCorpusList) {
                SubsetTreeJson.writeParentageDetail(jw, parameters, corpus);
            }
            jw.endArray();
        }
    }

    private static void writeThesaurusFieldKey(JSONWriter jw, Parameters parameters, Thesaurus thesaurus, ThesaurusFieldKey thesaurusFieldKey) throws IOException {
        String labelString;
        String patternType = thesaurusFieldKey.equals(ThesaurusFieldKey.THIS) ? SubsetTreeJson.getThesaurusPatternType(parameters, thesaurus.getSubsetKey()) : (thesaurusFieldKey.equals(ThesaurusFieldKey.IDALPHA) || thesaurusFieldKey.equals(ThesaurusFieldKey.PARENT_IDALPHA) ? "idalpha" : "value");
        Lang lang = parameters.getLang();
        MessageLocalisation messageLocalisation = parameters.getMessageLocalisation();
        jw.object();
        jw.key("key").value(thesaurusFieldKey.toString());
        jw.key("patternType").value(patternType);
        jw.key("title");
        String messageKey = L10nUtils.getMessageKey(thesaurusFieldKey);
        String value = null;
        if (thesaurusFieldKey.isLabelThesaurusFieldKey()) {
            value = messageLocalisation.toString(lang.toString());
        }
        if ((labelString = value == null ? messageLocalisation.toString(messageKey) : messageLocalisation.toString(messageKey, value)) != null) {
            jw.value(labelString);
        } else {
            jw.value("");
        }
        jw.endObject();
    }

    private static void writeCorpusField(JSONWriter jw, Parameters parameters, CorpusField corpusField) throws IOException {
        jw.object();
        CorpusFieldJson.properties(jw, corpusField, parameters.getLang());
        jw.endObject();
    }

    private static void writeCorpusInclude(JSONWriter jw, Parameters parameters, String specialIncludeName) throws IOException {
        String patternType = SubsetTreeJson.getSpecialPatternType(specialIncludeName);
        String title = L10nUtils.getSpecialIncludeTitle(parameters.getBdfServer(), specialIncludeName, parameters.getLang());
        if (title == null) {
            title = specialIncludeName;
        }
        SubsetTreeJson.includeObject(jw, specialIncludeName, patternType, title);
    }

    private static void writeCorpusInclude(JSONWriter jw, Parameters parameters, IncludeUi includeUi, String title) throws IOException {
        String patternType = includeUi instanceof SpecialIncludeUi ? SubsetTreeJson.getSpecialPatternType(includeUi.getName()) : (includeUi instanceof SubsetIncludeUi ? SubsetTreeJson.getSubsetPatternType(parameters, ((SubsetIncludeUi)includeUi).getSubsetKey()) : "");
        SubsetTreeJson.includeObject(jw, includeUi.getName(), patternType, title);
    }

    private static void includeObject(JSONWriter jw, String name, String patternType, String title) throws IOException {
        jw.object();
        jw.key("key").value(name);
        jw.key("patternType").value(patternType);
        jw.key("title").value(title);
        jw.endObject();
    }

    private static String getSubsetPatternType(Parameters parameters, SubsetKey subsetKey) {
        switch (subsetKey.getCategory()) {
            case 1: {
                return "fiche";
            }
            case 2: {
                return SubsetTreeJson.getThesaurusPatternType(parameters, subsetKey);
            }
            case 5: {
                return "illustration";
            }
            case 4: {
                return "document";
            }
        }
        throw new SwitchException("Unknown category: " + subsetKey.getCategory());
    }

    private static String getSpecialPatternType(String specialIncludeName) {
        switch (specialIncludeName) {
            case "liage": 
            case "parentage": {
                return "fiche";
            }
            case "date_creation": 
            case "date_modification": {
                return "date";
            }
        }
        throw new SwitchException("Unknown include name: " + specialIncludeName);
    }

    private static String getThesaurusPatternType(Parameters parameters, SubsetKey subsetKey) {
        Thesaurus thesaurus = (Thesaurus)parameters.getBdfServer().getFichotheque().getSubset(subsetKey);
        if (thesaurus != null) {
            switch (thesaurus.getThesaurusMetadata().getThesaurusType()) {
                case "babelien": {
                    return "motcle_babelien";
                }
                case "idalpha": {
                    return "motcle_idalpha";
                }
                case "multi": {
                    return "motcle_multi";
                }
            }
        }
        return "motcle_idalpha";
    }

    private static void writeParentageDetail(JSONWriter jw, Parameters parameters, Subset subset) throws IOException {
        Lang lang = parameters.getLang();
        SubsetKey subsetKey = subset.getSubsetKey();
        jw.object();
        if (subsetKey.isCorpusSubset()) {
            jw.key("key").value("fiche_" + subsetKey.getSubsetName());
            jw.key("patternType").value("fiche");
            jw.key("title").value(FichothequeUtils.getTitle((Corpus)subset, lang));
        } else if (subsetKey.isThesaurusSubset()) {
            jw.key("key").value("motcle_" + subsetKey.getSubsetName());
            jw.key("patternType").value(SubsetTreeJson.getThesaurusPatternType(parameters, subsetKey));
            jw.key("title").value(FichothequeUtils.getTitle((Thesaurus)subset, lang));
        }
        jw.endObject();
    }

    public static class Parameters {
        private final BdfServer bdfServer;
        private final Lang lang;
        private final MessageLocalisation messageLocalisation;
        private boolean withDetails;
        private PermissionSummary permissionSummary;

        public Parameters(BdfServer bdfServer, Lang lang, MessageLocalisation messageLocalisation) {
            this.bdfServer = bdfServer;
            this.lang = lang;
            this.messageLocalisation = messageLocalisation;
        }

        public BdfServer getBdfServer() {
            return this.bdfServer;
        }

        public Lang getLang() {
            return this.lang;
        }

        public MessageLocalisation getMessageLocalisation() {
            return this.messageLocalisation;
        }

        public boolean isWithDetails() {
            return this.withDetails;
        }

        public Parameters setWithDetails(boolean withDetails) {
            this.withDetails = withDetails;
            return this;
        }

        public PermissionSummary getPermissionSummary() {
            return this.permissionSummary;
        }

        public Parameters setWithPermissionSummary(PermissionSummary permissionSummary) {
            this.permissionSummary = permissionSummary;
            return this;
        }
    }
}

