/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.SelectionManager;
import fr.exemole.bdfserver.api.storage.SelectionStorage;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.impl.BdfUserImpl;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FichothequeQueries;
import net.fichotheque.selection.SelectionDef;

class SelectionManagerImpl
implements SelectionManager {
    private static final List<SelectionDef> EMPTY_LIST = Collections.emptyList();
    private final BdfServer bdfServer;
    private final SelectionStorage selectionStorage;
    private final SortedMap<String, SelectionDef> selectionDefMap = new TreeMap<String, SelectionDef>();
    private List<SelectionDef> selectionDefList = EMPTY_LIST;

    SelectionManagerImpl(BdfServer bdfServer, SelectionStorage selectionStorage) {
        this.bdfServer = bdfServer;
        this.selectionStorage = selectionStorage;
    }

    synchronized void check(List<SelectionDef> selectionDefList) {
        this.selectionDefMap.clear();
        for (SelectionDef scrutariExportDef : selectionDefList) {
            this.selectionDefMap.put(scrutariExportDef.getName(), scrutariExportDef);
        }
        this.updateList();
    }

    @Override
    public List<SelectionDef> getSelectionDefList() {
        return this.selectionDefList;
    }

    @Override
    public SelectionDef getSelectionDef(String name) {
        return (SelectionDef)this.selectionDefMap.get(name);
    }

    @Override
    public synchronized void putSelectionDef(SelectionDef selectionDef) {
        String name = selectionDef.getName();
        this.selectionDefMap.put(name, selectionDef);
        this.updateList();
        this.selectionStorage.saveSelectionDef(selectionDef);
    }

    @Override
    public synchronized void removeSelectionDef(String name) {
        boolean here = this.selectionDefMap.containsKey(name);
        if (!here) {
            return;
        }
        this.selectionDefMap.remove(name);
        this.selectionStorage.removeSelectionDef(name);
        this.updateList();
    }

    @Override
    public void updateFicheSelection(BdfUser bdfUser) {
        ((BdfUserImpl)bdfUser).updateFicheSelection(this.bdfServer, BdfUserUtils.getCurrentSortType(this.bdfServer, bdfUser));
    }

    @Override
    public void setFicheSelection(BdfUser bdfUser, FicheQuery ficheQuery, String sortType) {
        ((BdfUserImpl)bdfUser).setFicheSelection(this.bdfServer, ficheQuery, sortType);
    }

    @Override
    public void setFicheSelection(BdfUser bdfUser, FichothequeQueries fichothequeQueries, String sortType) {
        ((BdfUserImpl)bdfUser).setFicheSelection(this.bdfServer, fichothequeQueries, sortType);
    }

    @Override
    public void setFicheSelection(BdfUser bdfUser, String selectionDefName, String sortType) {
        ((BdfUserImpl)bdfUser).setFicheSelection(this.bdfServer, selectionDefName, sortType);
    }

    @Override
    public void setCustomSelectedFiches(BdfUser bdfUser, Fiches fiches) {
        ((BdfUserImpl)bdfUser).setSelectedFiches(fiches);
    }

    private void updateList() {
        this.selectionDefList = new SelectionDefList(this.selectionDefMap.values().toArray(new SelectionDef[this.selectionDefMap.size()]));
    }

    private static class SelectionDefList
    extends AbstractList<SelectionDef>
    implements RandomAccess {
        private final SelectionDef[] array;

        private SelectionDefList(SelectionDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SelectionDef get(int index) {
            return this.array[index];
        }
    }
}

