/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.MotcleAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.MotcleChangeFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.MotcleCreationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.MotcleIndexationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.MotclePonderationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.MotcleSelectionIndexationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.SelectionIndexationChoiceHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.SelectionIndexationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusCreationFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusMetadataFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusParameters;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public final class ThesaurusHtmlProducerFactory {
    private static final int THESAURUS_ADMIN = 1;
    private static final int MOTCLE_ADMIN = 3;

    private ThesaurusHtmlProducerFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        String page = parameters.getOutput();
        BdfServer bdfServer = parameters.getBdfServer();
        RequestMap requestMap = parameters.getRequestMap();
        switch (ThesaurusHtmlProducerFactory.getPageType(page)) {
            case 1: {
                Thesaurus thesaurus = requestHandler.getThesaurus();
                parameters.checkSubsetAdmin(thesaurus);
                switch (page) {
                    case "thesaurus-advancedcommands": {
                        return new ThesaurusAdvancedCommandsHtmlProducer(parameters, thesaurus);
                    }
                    case "thesaurus-metadataform": {
                        return new ThesaurusMetadataFormHtmlProducer(parameters, thesaurus);
                    }
                    case "motcle-creationform": {
                        Motcle parentMotcle = (Motcle)requestHandler.getOptionnalSubsetItem(thesaurus, "parent");
                        return new MotcleCreationFormHtmlProducer(parameters, thesaurus, parentMotcle);
                    }
                }
                return null;
            }
            case 3: {
                Motcle motcle = requestHandler.getMotcle();
                parameters.checkSubsetAdmin(motcle.getThesaurus());
                switch (page) {
                    case "motcle-advancedcommands": {
                        return new MotcleAdvancedCommandsHtmlProducer(parameters, motcle);
                    }
                    case "motcle-changeform": {
                        return new MotcleChangeFormHtmlProducer(parameters, motcle);
                    }
                    case "motcle-indexationform": {
                        return new MotcleIndexationFormHtmlProducer(parameters, motcle);
                    }
                    case "motcle-ponderationform": {
                        String sortValue = requestHandler.getTrimedParameter("sort", "corpusasc");
                        return new MotclePonderationFormHtmlProducer(parameters, motcle, sortValue);
                    }
                    case "motcle-selectionindexationform": {
                        String mode = requestHandler.getMode();
                        return new MotcleSelectionIndexationFormHtmlProducer(parameters, motcle, mode);
                    }
                    case "selectionindexation-form": {
                        String mode = requestHandler.getMode();
                        return new SelectionIndexationFormHtmlProducer(parameters, motcle, mode);
                    }
                }
                return null;
            }
        }
        switch (page) {
            case "thesaurus-creationform": {
                parameters.checkFichothequeAdmin();
                return new ThesaurusCreationFormHtmlProducer(parameters);
            }
            case "thesaurus": {
                Thesaurus thesaurus = requestHandler.getThesaurus();
                ThesaurusParameters thesaurusParameters = ThesaurusParameters.buildFromRequest(requestMap);
                BdfUser bdfUser = parameters.getBdfUser();
                if (thesaurusParameters == null) {
                    thesaurusParameters = ThesaurusParameters.buildFromThesaurus(bdfUser, thesaurus);
                    return new ThesaurusHtmlProducer(parameters, thesaurus, thesaurusParameters);
                }
                try (EditSession session = bdfServer.initEditSession(bdfUser, "thesaurus", page);){
                    thesaurusParameters.save(session.getBdfServerEditor(), bdfUser, thesaurus);
                    return new ThesaurusHtmlProducer(parameters, thesaurus, thesaurusParameters);
                }
            }
            case "selectionindexation-choice": {
                return new SelectionIndexationChoiceHtmlProducer(parameters);
            }
        }
        return null;
    }

    private static int getPageType(String page) {
        switch (page) {
            case "thesaurus-advancedcommands": 
            case "thesaurus-metadataform": 
            case "motcle-creationform": {
                return 1;
            }
            case "motcle-advancedcommands": 
            case "motcle-changeform": 
            case "motcle-indexationform": 
            case "motcle-ponderationform": 
            case "motcle-selectionindexationform": 
            case "selectionindexation-form": {
                return 3;
            }
        }
        return 0;
    }
}

