/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlUtils;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.localisation.Lang;

public class MotcleIndexationFormHtmlProducer
extends BdfServerHtmlProducer {
    private final Thesaurus thesaurus;
    private final Motcle motcle;
    private final PermissionSummary permissionSummary;
    private final boolean withFontAwesome;

    public MotcleIndexationFormHtmlProducer(BdfParameters bdfParameters, Motcle motcle) {
        super(bdfParameters);
        this.thesaurus = motcle.getThesaurus();
        this.motcle = motcle;
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addThemeCss("thesaurus.css");
        this.withFontAwesome = this.checkFontAwesome();
    }

    @Override
    public void printHtml() {
        Lang thesaurusLang = BdfServerUtils.checkLangDisponibility(this.bdfServer, this.thesaurus, this.workingLang);
        this.start();
        ThesaurusHtmlUtils.printMotcleToolBar(this, this.bdfServer, this.bdfUser, this.motcle, "motcle-indexationform", thesaurusLang, this.withFontAwesome);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("thesaurus").family("THS").veil(true).page("motcle-indexationform");
        ThesaurusCommandBoxUtils.printMotcleIndexationBox(this, commandBox, this.motcle, this.workingLang, this.permissionSummary);
        this.end();
    }
}

