/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.sphere;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereHtmlUtils;
import fr.exemole.bdfserver.tools.roles.PermissionCheck;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.html.CommandBox;

public class RedacteurAdminFormHtmlProducer
extends BdfServerHtmlProducer {
    private final PermissionSummary permissionSummary;
    private final Redacteur redacteur;

    public RedacteurAdminFormHtmlProducer(BdfParameters bdfParameters, Redacteur redacteur) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.redacteur = redacteur;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addThemeCss("sphere.css");
    }

    @Override
    public void printHtml() {
        this.start();
        SphereHtmlUtils.printRedacteurToolbar(this, "redacteur-adminform", this.redacteur);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("sphere").family("USR").veil(true).page("redacteur-adminform");
        boolean sphereSupervisorAllowed = PermissionCheck.isAllowedBySphereSupervisor(this.bdfServer, this.bdfUser, this.redacteur.getSubsetName());
        if (sphereSupervisorAllowed) {
            SphereCommandBoxUtils.printRedacteurChangeBox(this, commandBox, this.redacteur, this.bdfServer);
            SphereCommandBoxUtils.printLoginChangeBox(this, commandBox, this.redacteur);
        } else {
            SphereCommandBoxUtils.printNotAllowed(this, commandBox, "_ USR-01");
            SphereCommandBoxUtils.printNotAllowed(this, commandBox, "_ SPH-10");
        }
        if (!this.bdfServer.getPermissionManager().isAdmin(this.redacteur)) {
            SphereCommandBoxUtils.printRedacteurStatusBox(this, commandBox, this.redacteur);
        } else {
            SphereCommandBoxUtils.printNotAvailableCommand(this, commandBox, "_ SPH-05", "_ info.sphere.adminactive");
        }
        if (!this.redacteur.isInactive()) {
            CommandBox roleCommandBox = CommandBox.init().action("sphere").family("ROL").veil(true).page("redacteur-adminform");
            if (this.permissionSummary.isFichothequeAdmin()) {
                SphereCommandBoxUtils.printRedacteurRoleBox(this, roleCommandBox, this.bdfServer, this.bdfUser.getWorkingLang(), this.redacteur);
            }
            if (sphereSupervisorAllowed) {
                SphereCommandBoxUtils.printRedacteurPasswordBox(this, commandBox, this.redacteur);
            } else {
                SphereCommandBoxUtils.printNotAllowed(this, commandBox, "_ USR-03");
            }
        }
        this.end();
    }
}

