/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.pioche;

import fr.exemole.bdfserver.htmlproducers.pioche.PiocheParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.text.StringUtils;

public class PiocheArgs
implements Consumer<HtmlPrinter> {
    private final JsObject args;
    private final JsObject buttons;
    private final List<JsObject> hiddenValues = new ArrayList<JsObject>();

    public PiocheArgs() {
        this.args = new JsObject();
        this.buttons = new JsObject();
    }

    public PiocheArgs clientId(String clientId) {
        this.args.put("clientId", clientId);
        return this;
    }

    public PiocheArgs json(String json) {
        this.args.put("json", json);
        return this;
    }

    public PiocheArgs count(int count) {
        this.args.put("count", count);
        return this;
    }

    public PiocheArgs wanted(String wanted) {
        this.args.put("wanted", wanted);
        return this;
    }

    public PiocheArgs separator(String separator) {
        this.args.put("separator", separator);
        return this;
    }

    public PiocheArgs newfiche(String newficheLabel) {
        if (newficheLabel != null) {
            this.args.put("newfiche", newficheLabel);
        }
        return this;
    }

    public PiocheArgs subsets(String subsets) {
        if (subsets != null) {
            this.addHiddenValue("subsets", subsets);
        }
        return this;
    }

    public PiocheArgs subsets(List<Subset> subsetList) {
        if (subsetList != null && !subsetList.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            int size = subsetList.size();
            for (int i = 0; i < size; ++i) {
                Subset subset = subsetList.get(i);
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(subset.getSubsetName());
            }
            this.addHiddenValue("subsets", buf.toString());
        }
        return this;
    }

    public PiocheArgs defaultsphere(String defaultSphere) {
        if (defaultSphere != null) {
            this.addHiddenValue("defaultsphere", defaultSphere);
        }
        return this;
    }

    public PiocheArgs fieldtype(String fieldType) {
        if (fieldType != null) {
            this.addHiddenValue("fieldtype", fieldType);
        }
        return this;
    }

    public PiocheArgs populate(PiocheParameters piocheParameters) {
        return this.populate(piocheParameters, null);
    }

    public PiocheArgs populate(PiocheParameters piocheParameters, Set<String> allowedButtonSet) {
        String buttonsString;
        this.args.put("appelant", piocheParameters.getAppelant()).put("limit", piocheParameters.getLimit());
        SubsetKey junctionKey = (SubsetKey)piocheParameters.getParameter("junction");
        if (junctionKey != null) {
            this.addHiddenValue("junction", junctionKey.getKeyString());
        }
        if (allowedButtonSet != null && (buttonsString = (String)piocheParameters.getParameter("buttons")) != null) {
            for (String token : StringUtils.getTechnicalTokens(buttonsString, true)) {
                if (!allowedButtonSet.contains(token)) continue;
                this.buttons.put(token, Boolean.TRUE);
            }
        }
        return this;
    }

    private void addHiddenValue(String name, String value) {
        this.hiddenValues.add(JsObject.init().put("name", name).put("value", value));
    }

    public static PiocheArgs init() {
        return new PiocheArgs();
    }

    @Override
    public void accept(HtmlPrinter hp) {
        this.args.put("buttons", this.buttons);
        this.args.put("hiddenValues", this.hiddenValues);
        hp.SCRIPT().__jsObject("Pioche.ARGS", this.args)._SCRIPT();
    }
}

