/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.main;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.api.users.BdfUserPrefsEditor;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.CollectionsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.FichesHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.IframesHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.MainHtmlUtils;
import fr.exemole.bdfserver.htmlproducers.main.NoScriptMenuHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.StartHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.TableSheetHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import net.fichotheque.Subset;
import net.fichotheque.exportation.table.TableExportDescription;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.logging.ErrorMessageException;

public final class MainHtmlProducerFactory {
    private MainHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page;
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        switch (page = parameters.getOutput()) {
            case "iframes": {
                return new IframesHtmlProducer(parameters, MainHtmlUtils.getMainProvider(parameters.getRequestMap()));
            }
            case "menu": {
                return new NoScriptMenuHtmlProducer(parameters);
            }
            case "start": {
                return new StartHtmlProducer(parameters);
            }
            case "collections": {
                return new CollectionsHtmlProducer(parameters);
            }
            case "fiches": {
                MainHtmlProducerFactory.testFichesReload(requestHandler);
                return new FichesHtmlProducer(parameters, MainHtmlUtils.getFiches(requestHandler));
            }
            case "tablesheet": {
                TableExportDescription tableExportDescription = null;
                String tableExportName = requestHandler.getTrimedParameter("tableexport");
                if (!tableExportName.isEmpty()) {
                    tableExportDescription = requestHandler.getMandatoryTableExportDescription();
                }
                Subset subset = requestHandler.getMandatorySubset();
                if (requestHandler.isTrue("remember_action")) {
                    MainHtmlProducerFactory.saveTableSheetPrefs(parameters, tableExportDescription, subset);
                }
                return new TableSheetHtmlProducer(parameters, tableExportDescription, subset);
            }
        }
        return null;
    }

    public static void testFichesReload(RequestHandler requestHandler) {
        if (requestHandler.isTrue("reload")) {
            requestHandler.getBdfServer().getSelectionManager().updateFicheSelection(requestHandler.getBdfUser());
        }
    }

    private static void saveTableSheetPrefs(BdfParameters bdfParameters, TableExportDescription tableExportDescription, Subset subset) {
        BdfUser bdfUser = bdfParameters.getBdfUser();
        AttributeKey attributeKey = BdfUserSpace.toTableAttributeKey(subset);
        Attribute currentAttribute = bdfUser.getPrefs().getAttributes().getAttribute(attributeKey);
        try (EditSession session = bdfParameters.getBdfServer().initEditSession(bdfUser, "main", "tablesheet");){
            BdfUserPrefsEditor bdfUserPrefsEditor = session.getBdfServerEditor().getBdfUserPrefsEditor(bdfUser.getPrefs());
            if (tableExportDescription == null) {
                if (currentAttribute != null) {
                    bdfUserPrefsEditor.removeAttribute(attributeKey);
                }
            } else {
                Attribute newAttribute = AttributeBuilder.toAttribute(attributeKey, tableExportDescription.getName());
                boolean equality = false;
                if (currentAttribute != null) {
                    equality = AttributeUtils.isEqual(currentAttribute, newAttribute);
                }
                if (!equality) {
                    bdfUserPrefsEditor.putAttribute(newAttribute);
                }
            }
        }
    }
}

