/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.mailing;

import fr.exemole.bdfserver.api.exportation.table.TableExportParameters;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.email.EmailBuffer;
import fr.exemole.bdfserver.email.FicheAttachmentParameters;
import fr.exemole.bdfserver.email.TableExportEmail;
import fr.exemole.bdfserver.email.ValidAddress;
import fr.exemole.bdfserver.email.WrongAddress;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.JunctionSelection;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.SubsetTitle;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.forms.TableExportFormHtml;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TransformationDescription;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.junction.Junctions;
import net.fichotheque.tools.exportation.transformation.TransformationCheck;
import net.fichotheque.utils.AddendaUtils;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;

public class SendFormHtmlProducer
extends BdfServerHtmlProducer {
    private static final HtmlWrapper VERSION_BRANCH = Tree.branch("mailing-VersionBranch");
    private final String sendType;
    private final EmailBuffer emailBuffer;
    private FicheMeta uniqueFicheMeta;
    private Set<FicheMeta> ficheMetaSet;

    public SendFormHtmlProducer(BdfParameters bdfParameters, EmailBuffer emailBuffer) {
        super(bdfParameters);
        this.sendType = emailBuffer.getSendType();
        this.emailBuffer = emailBuffer;
        switch (this.sendType) {
            case "fiche": {
                this.uniqueFicheMeta = (FicheMeta)emailBuffer.getSendObject();
                break;
            }
            case "selection": {
                this.ficheMetaSet = (Set)emailBuffer.getSendObject();
                break;
            }
        }
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.APPELANT);
        this.addThemeCss("mailing.css");
    }

    @Override
    public void printHtml() {
        this.start();
        this.__(PageUnit.start("action-Send", SendFormHtmlProducer.getTitleMessageKey(this.sendType))).FORM_post(HA.action("mailing").attr("data-submit-process", "test")).INPUT_hidden(this.initParametersMap()).__(this.printSendReport()).__(this.printToInput()).__(this.printCcInput()).__(this.printBccInput()).__(this.printSubjectInput()).__(this.printMessageInput()).__(this.printAttachments()).__(Button.COMMAND, Button.submit("action-Send", SendFormHtmlProducer.getSubmitMessageKey(this.sendType)))._FORM().__(PageUnit.END);
        this.end();
    }

    private ParameterMap initParametersMap() {
        ParameterMap parametersMap = ParameterMap.init().command("Send").page("send-report").errorPage("send-form").param("type", this.sendType);
        if (this.sendType.equals("fiche")) {
            parametersMap.subset(this.uniqueFicheMeta.getCorpus()).subsetItem(this.uniqueFicheMeta);
        } else if (this.sendType.equals("tableexport")) {
            TableExportEmail tableExportEmail = (TableExportEmail)this.emailBuffer.getSendObject();
            parametersMap.subset(tableExportEmail.getCorpus());
        }
        return parametersMap;
    }

    private boolean printToInput() {
        HtmlAttributes toInput = this.name("to").cols(60).rows(4).populate(Appelant.user().sphere(this.bdfUser));
        this.P("mailing-InputParagraph").LABEL_for(toInput.id()).__localize("_ label.mailing.to").__colon()._LABEL().TEXTAREA(toInput).__(this.printValidAddresses("to"))._TEXTAREA()._P();
        return true;
    }

    private boolean printCcInput() {
        HtmlAttributes ccInput = this.name("cc").cols(60).rows(3).populate(Appelant.user().sphere(this.bdfUser));
        this.P("mailing-InputParagraph").LABEL_for(ccInput.id()).__localize("_ label.mailing.cc").__colon()._LABEL().TEXTAREA(ccInput).__(this.printValidAddresses("cc"))._TEXTAREA()._P();
        return true;
    }

    private boolean printBccInput() {
        HtmlAttributes bccInput = this.name("bcc").cols(60).rows(3).populate(Appelant.user().sphere(this.bdfUser));
        HtmlAttributes selfBccCheck = this.name("selfbcc").value("1").checked(this.emailBuffer.isWithRedacteurBcc());
        this.P("mailing-InputParagraph").LABEL_for(bccInput.id()).__localize("_ label.mailing.bcc").__colon()._LABEL().TEXTAREA(bccInput).__(this.printValidAddresses("bcc"))._TEXTAREA().BR().SPAN("command-FlexInput mailing-SelfBcc").INPUT_checkbox(selfBccCheck).LABEL_for(selfBccCheck.id()).__localize("_ label.mailing.selfbcc")._LABEL()._P();
        return true;
    }

    private boolean printValidAddresses(String fieldName) {
        List<ValidAddress> validAddressList = this.emailBuffer.getValidAddressList(fieldName);
        if (validAddressList.isEmpty()) {
            return false;
        }
        for (ValidAddress validAddress : validAddressList) {
            this.__escape(validAddress.getOrginalString(), true).__newLine();
        }
        return true;
    }

    private boolean printSubjectInput() {
        String inputId = this.generateId();
        this.P("mailing-InputParagraph").LABEL_for(inputId).__localize("_ label.mailing.subject").__colon()._LABEL().INPUT_text(HA.name("subject").id(inputId).value(this.emailBuffer.getSubject()).size("60"))._P();
        return true;
    }

    private boolean printMessageInput() {
        String inputId = this.generateId();
        String message = this.emailBuffer.getMessage();
        if (message == null) {
            message = "";
        }
        this.P("mailing-InputParagraph").LABEL_for(inputId).__localize("_ label.mailing.message").__colon()._LABEL().TEXTAREA(HA.name("message").id(inputId).cols(72).rows(10)).__escape(message, true)._TEXTAREA()._P();
        return true;
    }

    private boolean printAttachments() {
        switch (this.sendType) {
            case "compilation": {
                this.printSendCompilation();
                break;
            }
            case "fiche": {
                this.printSendFiche();
                break;
            }
            case "selection": {
                this.printSendSelection();
                break;
            }
            case "tableexport": {
                this.printSendTableExport();
            }
        }
        return true;
    }

    private boolean printSendReport() {
        this.printCommandMessage();
        if (this.emailBuffer.hasWrongAddresses()) {
            this.__(Grid.START).__(this.printWrongAddresses("to", "to")).__(this.printWrongAddresses("cc", "cc")).__(this.printWrongAddresses("bcc", "bcc")).__(Grid.END);
        }
        return true;
    }

    private boolean printWrongAddresses(String fieldName, String inputName) {
        for (WrongAddress wrongAddress : this.emailBuffer.getWrongAddressList(fieldName)) {
            HtmlAttributes input = this.name(inputName).value(wrongAddress.getErrorValue()).size("60");
            this.P("grid-Row mailing-WrongAddress").__(Grid.labelCells(wrongAddress.getErrorMessage(), input.id())).__(Grid.START_INPUTCELL).INPUT_text(input).__(Grid.END_INPUTCELL)._P();
        }
        return true;
    }

    private void printSendCompilation() {
        FicheAttachmentParameters ficheAttachmentParameters = this.emailBuffer.getFicheAttachmentParameters();
        this.H2().__localize("_ title.mailing.compilationversion")._H2().UL("mailing-AttachmentList").__(new TemplateSelection(TransformationKey.COMPILATION_INSTANCE, ficheAttachmentParameters))._UL().H2().__localize("_ title.mailing.fiches_compilation")._H2().__(this.printFiches(this.bdfUser.getSelectedFiches(), false));
    }

    private void printSendSelection() {
        FicheAttachmentParameters ficheAttachmentParameters = this.emailBuffer.getFicheAttachmentParameters();
        Fiches fiches = this.bdfUser.getSelectedFiches();
        TransformationKey transformationKey = fiches.getEntryList().size() == 1 ? new TransformationKey(fiches.getEntryList().get(0).getCorpus().getSubsetKey()) : null;
        this.H2().__localize("_ title.mailing.selectionversion")._H2().UL("mailing-AttachmentList").__(new TemplateSelection(transformationKey, ficheAttachmentParameters))._UL().H2().__localize("_ title.mailing.fiches_selection")._H2().__(this.printFiches(this.bdfUser.getSelectedFiches(), true));
    }

    private void printSendTableExport() {
        boolean charsetHidden;
        TableExportEmail tableExportEmail = (TableExportEmail)this.emailBuffer.getSendObject();
        TableExportParameters tableExportParameters = tableExportEmail.getTableExportParameters();
        String tableExportName = tableExportParameters.getTableExportName();
        TableExportDescription tableExportDescription = tableExportName != null ? BdfTableExportUtils.getValidTableExportDescription(this.bdfServer.getTableExportManager(), tableExportName) : null;
        String charsetPanelId = this.generateId();
        boolean bl = charsetHidden = this.isWithJavascript() && !tableExportEmail.getExtension().equals("csv");
        if (tableExportDescription != null) {
            this.H2().__localize("_ label.tableexport.tableexport_name").__space().STRONG().__escape(tableExportDescription.getTitle(this.workingLang))._STRONG()._H2().INPUT_hidden("tableexport", tableExportName);
        } else {
            this.H2().__localize("_ label.tableexport.tableexport_default")._H2().__(TableExportFormHtml.printWithParameters(this, tableExportParameters.getDefaulFicheTableParameters())).__(TableExportFormHtml.printPatternModeRadios(this, tableExportParameters.getDefaulFicheTableParameters().getPatternMode()));
        }
        this.__(TableExportFormHtml.HEADERTYPE_TITLE).__(TableExportFormHtml.printHeaderTypeRadios(this, tableExportParameters.getHeaderType())).H2().__localize("_ title.tableexport.extension")._H2().UL("mailing-AttachmentList").LI().__(this.printExtensionRadio(tableExportEmail, "csv", charsetPanelId, "action-Csv")).DIV(Grid.detailPanelTable().id(charsetPanelId).addClass(charsetHidden, "hidden")).__(Grid.selectRow((Object)"_ label.global.charset", this.name("charset").classes("global-CharsetSelect"), new CharsetOptions(tableExportEmail.getCharset())))._DIV()._LI().LI().__(this.printExtensionRadio(tableExportEmail, "ods", null, "action-Ods"))._LI()._UL().H2().__localize("_ title.mailing.fiches_tableexport")._H2().__(this.printFiches(CorpusUtils.reduce(this.bdfUser.getSelectedFiches(), tableExportEmail.getCorpus()), false));
    }

    private boolean printSendFiche() {
        FicheAttachmentParameters ficheAttachmentParameters = this.emailBuffer.getFicheAttachmentParameters();
        DocumentBranch documentBranch = new DocumentBranch(this.getFormatLocale(), ficheAttachmentParameters);
        this.H2().__localize("_ title.mailing.sendreport_attachments")._H2().H3().__escape(CorpusMetadataUtils.getFicheTitle(this.uniqueFicheMeta, this.workingLang, this.formatLocale))._H3().UL("mailing-AttachmentList").__(new TemplateSelection(this.uniqueFicheMeta.getCorpus(), ficheAttachmentParameters))._UL();
        boolean first = true;
        for (Addenda addenda : this.fichotheque.getAddendaList()) {
            Junctions documentJunctions = this.fichotheque.getJunctions(this.uniqueFicheMeta, addenda);
            if (documentJunctions.isEmpty()) continue;
            if (first) {
                this.H3().__localize("_ title.mailing.documentlist")._H3().UL("global-JunctionList");
                first = false;
            }
            this.LI().P().__(SubsetTitle.init(addenda, this.workingLang).subsetIcon(true))._P().__(JunctionSelection.TREE, () -> {
                for (Junctions.Entry entry : documentJunctions.getEntryList()) {
                    this.__(documentBranch, entry.getSubsetItem());
                }
            })._LI();
        }
        if (!first) {
            this._UL();
        }
        return true;
    }

    private boolean printFiches(Fiches fiches, boolean withCheckbox) {
        this.UL("global-JunctionList");
        for (Fiches.Entry entry : fiches.getEntryList()) {
            Corpus corpus = entry.getCorpus();
            this.LI().P().__(SubsetTitle.init(corpus, this.workingLang).subsetIcon(true))._P().__(JunctionSelection.TREE, () -> {
                for (FicheMeta ficheMeta : entry.getFicheMetaList()) {
                    if (withCheckbox) {
                        boolean checked = this.ficheMetaSet != null && this.ficheMetaSet.contains(ficheMeta);
                        HtmlAttributes inputAttributes = this.name("selection_" + corpus.getSubsetName()).value(String.valueOf(ficheMeta.getId())).checked(checked);
                        this.__(Tree.checkboxLeaf(inputAttributes, () -> this.__escape(CorpusMetadataUtils.getFicheTitle(ficheMeta, this.workingLang, this.formatLocale))));
                        continue;
                    }
                    this.__(Tree.LEAF, () -> this.SPAN("mailing-Fiche").__escape(CorpusMetadataUtils.getFicheTitle(ficheMeta, this.workingLang, this.formatLocale))._SPAN());
                }
            })._LI();
        }
        this._UL();
        return true;
    }

    private boolean printExtensionRadio(TableExportEmail tableExportEmail, String extension, String targetId, String actionName) {
        HtmlAttributes radio = this.name("extension").value(extension).checked(tableExportEmail.getExtension());
        if (targetId != null) {
            radio.populate(Deploy.radio(targetId));
        }
        this.P("command-FlexInput " + actionName).INPUT_radio(radio).__(Button.ICON).LABEL_for(radio.id()).__escape(extension)._LABEL()._P();
        return true;
    }

    private static String getSubmitMessageKey(String sendType) {
        switch (sendType) {
            case "fiche": {
                return "_ submit.mailing.send_fiche";
            }
            case "compilation": {
                return "_ submit.mailing.send_compilation";
            }
            case "selection": {
                return "_ submit.mailing.send_selection";
            }
            case "tableexport": {
                return "_ submit.mailing.send_tableexport";
            }
        }
        throw new SwitchException("Unknown sendType: " + sendType);
    }

    private static String getTitleMessageKey(String sendType) {
        switch (sendType) {
            case "fiche": {
                return "_ title.mailing.send_fiche";
            }
            case "compilation": {
                return "_ title.mailing.send_compilation";
            }
            case "selection": {
                return "_ title.mailing.send_selection";
            }
            case "tableexport": {
                return "_ title.mailing.send_tableexport";
            }
        }
        throw new SwitchException("Unknown sendType: " + sendType);
    }

    private class TemplateSelection
    implements Consumer<HtmlPrinter> {
        private final Map<String, TemplateCheckboxes> checkboxesMap = new HashMap<String, TemplateCheckboxes>();
        private final TransformationCheck transformationCheck;
        private final FicheAttachmentParameters ficheAttachmentParameters;

        private TemplateSelection(TransformationKey transformationKey, FicheAttachmentParameters ficheAttachmentParameters) {
            if (transformationKey != null) {
                TransformationDescription transformationDescription = SendFormHtmlProducer.this.bdfServer.getTransformationManager().getTransformationDescription(transformationKey);
                this.transformationCheck = TransformationCheck.check(transformationDescription, true);
            } else {
                this.transformationCheck = null;
            }
            this.ficheAttachmentParameters = ficheAttachmentParameters;
            this.addHtml();
            this.addOdt();
        }

        private TemplateSelection(Corpus corpus, FicheAttachmentParameters ficheAttachmentParameters) {
            this(new TransformationKey(corpus.getSubsetKey()), ficheAttachmentParameters);
        }

        private void addHtml() {
            String name = "html";
            TemplateCheckboxes templateCheckboxes = new TemplateCheckboxes(name, "html", "_ label.mailing.format_html", "htmltemplate", this.ficheAttachmentParameters.isWithHtml(), this.ficheAttachmentParameters.getHtmlTemplateName(), "action-Html");
            this.checkboxesMap.put(name, templateCheckboxes);
        }

        private void addOdt() {
            String name = "odt";
            TemplateCheckboxes templateCheckboxes = new TemplateCheckboxes(name, "odt", "_ label.mailing.format_odt", "odttemplate", this.ficheAttachmentParameters.isWithOdt(), this.ficheAttachmentParameters.getOdtTemplateName(), "action-Odt");
            this.checkboxesMap.put(name, templateCheckboxes);
        }

        @Override
        public void accept(HtmlPrinter hp) {
            this.accept("html", hp);
            this.accept("odt", hp);
        }

        private void accept(String name, HtmlPrinter hp) {
            TemplateCheckboxes templateCheckboxes = this.checkboxesMap.get(name);
            if (templateCheckboxes != null) {
                templateCheckboxes.accept(hp);
            }
        }

        private class TemplateCheckboxes
        implements Consumer<HtmlPrinter> {
            private final String name;
            private final String value;
            private final String locKey;
            private final boolean checked;
            private final String templateSelectName;
            private final String selectedTemplateName;
            private final String actionName;

            private TemplateCheckboxes(String name, String value, String locKey, String templateSelectName, boolean checked, String selectedTemplateName, String actionName) {
                this.name = name;
                this.value = value;
                this.locKey = locKey;
                this.templateSelectName = templateSelectName;
                this.checked = checked;
                this.actionName = actionName;
                this.selectedTemplateName = selectedTemplateName == null ? "_default" : selectedTemplateName;
            }

            @Override
            public void accept(HtmlPrinter hp) {
                TemplateDescription[] templateDescriptionArray = this.getTemplateDescriptionArray();
                String detailId = null;
                HtmlAttributes checkbox = hp.name("ficheversion").value(this.value).checked(this.checked);
                if (templateDescriptionArray != null) {
                    detailId = hp.generateId();
                    checkbox.populate(Deploy.checkbox(detailId));
                }
                hp.LI().P("command-FlexInput " + this.actionName).INPUT_checkbox(checkbox).__(Button.ICON).LABEL_for(checkbox.id()).__localize(this.locKey)._LABEL()._P();
                if (templateDescriptionArray != null) {
                    hp.DIV(Grid.detailPanelTable().id(detailId).addClass(!this.checked, "hidden")).__(Grid.selectRow((Object)"_ label.transformation.template", SendFormHtmlProducer.this.name(this.templateSelectName), new TemplateOptions(templateDescriptionArray)))._DIV();
                }
                hp._LI();
            }

            private TemplateDescription[] getTemplateDescriptionArray() {
                if (TemplateSelection.this.transformationCheck == null) {
                    return null;
                }
                if (this.name.equals("html")) {
                    return TemplateSelection.this.transformationCheck.getSimpleTemplateDescriptionArray();
                }
                return TemplateSelection.this.transformationCheck.getStreamTemplateDescriptionArray(this.name);
            }

            class TemplateOptions
            implements Consumer<HtmlPrinter> {
                private final TemplateDescription[] templateDescriptionArray;

                private TemplateOptions(TemplateDescription[] templateDescriptionArray) {
                    this.templateDescriptionArray = templateDescriptionArray;
                }

                @Override
                public void accept(HtmlPrinter hp) {
                    hp.OPTION("_default", TemplateCheckboxes.this.selectedTemplateName.equals("_default")).__localize("_ label.transformation.defaulttemplate")._OPTION();
                    for (TemplateDescription templateDescription : this.templateDescriptionArray) {
                        String name = templateDescription.getTemplateKey().getName();
                        hp.OPTION(name, name.equals(TemplateCheckboxes.this.selectedTemplateName)).__escape(templateDescription.getTitle(SendFormHtmlProducer.this.workingLang))._OPTION();
                    }
                }
            }
        }
    }

    private static class CharsetOptions
    implements Consumer<HtmlPrinter> {
        private final String currentCharset;

        private CharsetOptions(String currentCharset) {
            this.currentCharset = currentCharset;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            SortedMap<String, Charset> charsetMap = Charset.availableCharsets();
            for (Map.Entry<String, Charset> entry : charsetMap.entrySet()) {
                String canonicalName = entry.getKey();
                Charset charset = entry.getValue();
                boolean selected = canonicalName.equals(this.currentCharset);
                hp.OPTION(canonicalName, selected).__escape(canonicalName);
                Set<String> aliases = charset.aliases();
                for (String alias : aliases) {
                    hp.__escape(" ; ").__escape(alias);
                }
                hp._OPTION();
            }
        }
    }

    private static class DocumentBranch
    implements BiConsumer<HtmlPrinter, Object> {
        private final Locale formatLocale;
        private final FicheAttachmentParameters ficheAttachmentParameters;

        private DocumentBranch(Locale formatLocale, FicheAttachmentParameters ficheAttachmentParameters) {
            this.formatLocale = formatLocale;
            this.ficheAttachmentParameters = ficheAttachmentParameters;
        }

        @Override
        public void accept(HtmlPrinter hp, Object object) {
            Document document = (Document)object;
            hp.__(JunctionSelection.OPEN_NODE, () -> hp.DIV("mailing-Document").__escape(document.getGlobalId()).__dash().__escape(document.getBasename())._DIV().__(VERSION_BRANCH, () -> {
                for (Version version : document.getVersionList()) {
                    String versionKey = AddendaUtils.toVersionKey(version);
                    HtmlAttributes inputAttributes = hp.name("documentversion").value(versionKey).checked(this.ficheAttachmentParameters.containsVersion(versionKey));
                    hp.__(Tree.checkboxLeaf(inputAttributes, () -> hp.SPAN("mailing-Version").__escape(version.getFileName())._SPAN().SPAN("mailing-Size").__space().__escape('(').__(BdfHtmlUtils.printDocumentVersionSize(hp, version, this.formatLocale)).__escape(')')._SPAN()));
                }
            }));
        }
    }
}

