/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.htmlproducers.edition.EditionHtmlUtils;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.logging.LogUtils;

public class SatelliteFicheCreationHtmlProducer
extends BdfServerHtmlProducer {
    private static final Button NEW_BUTTON = Button.submit("action-FicheCreate", "_ label.edition.satellite_creation");
    private final PermissionSummary permissionSummary;
    private final Corpus corpus;
    private final Subset masterSubset;
    private final Map<Object, SubsetItem> subsetItemMap;
    private final String corpusTitle;
    private Lang thesaurusLang;
    private final short masterCategory;

    public SatelliteFicheCreationHtmlProducer(BdfParameters bdfParameters, Corpus corpus) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.corpus = corpus;
        this.masterSubset = corpus.getMasterSubset();
        if (this.masterSubset instanceof Corpus) {
            this.subsetItemMap = new TreeMap<Object, SubsetItem>();
        } else if (this.masterSubset instanceof Thesaurus) {
            this.subsetItemMap = new LinkedHashMap<Object, SubsetItem>();
            this.thesaurusLang = BdfServerUtils.checkLangDisponibility(this.bdfServer, (Thesaurus)this.masterSubset, this.workingLang);
        } else {
            throw new UnsupportedOperationException("Unable to deal with masterSubsetCategory: " + this.masterSubset.getSubsetKeyString());
        }
        this.masterCategory = this.masterSubset.getSubsetKey().getCategory();
        this.initSubsetItemMap();
        this.corpusTitle = FichothequeUtils.getTitle(corpus, this.workingLang);
    }

    @Override
    public void printHtml() {
        String masterSubsetTitle = FichothequeUtils.getTitle(this.masterSubset, this.workingLang);
        this.start();
        if (this.subsetItemMap.isEmpty()) {
            this.setCommandMessage(LogUtils.error(EditionHtmlUtils.getSatelliteAllErrMessageKey(this.masterCategory), this.corpusTitle, masterSubsetTitle));
            this.printCommandMessageUnit();
        } else {
            HtmlAttributes select = this.name("id");
            this.__(PageUnit.start("action-FicheCreate", new Litteral(CorpusMetadataUtils.getNewFicheLabel(this.corpus, this.workingLang)))).P().__localize(EditionHtmlUtils.getSatelliteInfoMessageKey(this.masterCategory), this.corpusTitle, masterSubsetTitle)._P().FORM_get("edition").INPUT_hidden(ParameterMap.init().subset(this.corpus).page("fiche-change").param("force", "1")).P().LABEL_for(select.id()).__localize(EditionHtmlUtils.getMasterSelectMessageKey(this.masterCategory))._LABEL().__colon()._P().DIV("grid-InputCell").SELECT(select).__(this.printOptions())._SELECT()._DIV().__(Button.COMMAND, NEW_BUTTON)._FORM().__(PageUnit.END);
        }
        this.end();
    }

    private boolean printOptions() {
        for (SubsetItem subsetItem : this.subsetItemMap.values()) {
            if (subsetItem instanceof FicheMeta) {
                this.printOption((FicheMeta)subsetItem);
                continue;
            }
            if (!(subsetItem instanceof Motcle)) continue;
            this.printOption((Motcle)subsetItem);
        }
        return true;
    }

    private boolean printOption(FicheMeta ficheMeta) {
        String ficheTitle = CorpusMetadataUtils.getFicheTitle(ficheMeta, this.workingLang, this.bdfUser.getFormatLocale());
        this.OPTION(String.valueOf(ficheMeta.getId()), false).__escape(ficheTitle)._OPTION();
        return true;
    }

    private boolean printOption(Motcle motcle) {
        this.OPTION(String.valueOf(motcle.getId()), false);
        for (int i = 1; i < motcle.getLevel(); ++i) {
            this.__doublespace();
        }
        this.__(BdfHtmlUtils.printMotcleTitle(this, motcle, this.thesaurusLang))._OPTION();
        return true;
    }

    private void initSubsetItemMap() {
        if (!this.permissionSummary.canCreate(this.corpus)) {
            return;
        }
        if (this.masterSubset instanceof Corpus) {
            for (SubsetItem subsetItem : this.masterSubset.getSubsetItemList()) {
                int id = subsetItem.getId();
                if (this.corpus.getFicheMetaById(id) != null) continue;
                this.subsetItemMap.put(id, subsetItem);
            }
        } else {
            List<Motcle> motcleList = ThesaurusUtils.toHierarchicMotcleList((Thesaurus)this.masterSubset);
            for (Motcle motcle : motcleList) {
                int id = motcle.getId();
                if (this.corpus.getFicheMetaById(id) != null) continue;
                this.subsetItemMap.put(id, motcle);
            }
        }
    }
}

