/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.ficheform.FormEntryProvider;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.instruction.PermissionException;
import fr.exemole.bdfserver.api.namespaces.CommandSpace;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.CreationConfirmHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FicheFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FicheIndexationHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FicheResultHandler;
import fr.exemole.bdfserver.htmlproducers.edition.FicheResultHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.SatelliteFicheCreationHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.SectionPreviewHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.ZoomEditHtmlProducer;
import fr.exemole.bdfserver.tools.ficheform.FicheFormParametersBuilder;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.FormEntryProviderFactory;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.roles.PermissionCheck;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.tools.duplication.DuplicationFilter;
import net.fichotheque.tools.duplication.DuplicationFilterParser;
import net.fichotheque.tools.duplication.DuplicationUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.logging.ErrorMessageException;

public final class EditionHtmlProducerFactory {
    private EditionHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page;
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        switch (page = parameters.getOutput()) {
            case "zoomedit": {
                String appelant = requestHandler.getMandatoryParameter("appelant");
                String corpusName = requestHandler.getMandatoryParameter("corpus");
                return new ZoomEditHtmlProducer(parameters, appelant, corpusName);
            }
            case "fiche-result": {
                FicheResultHandler ficheResultHandler = FicheResultHandler.build(requestHandler.getFicheMeta(), requestHandler);
                return new FicheResultHtmlProducer(parameters, ficheResultHandler);
            }
            case "fiche-indexation": {
                FicheMeta ficheMeta = requestHandler.getFicheMeta();
                parameters.checkSubsetAdmin(ficheMeta.getCorpus());
                FichePointeur fichePointeur = PointeurFactory.newFichePointeur(ficheMeta.getCorpus()).setCurrentFicheMeta(ficheMeta);
                FormEntryProvider formEntryProvider = FormEntryProviderFactory.newInstance(FicheFormParametersBuilder.build(parameters).toFicheFormParameters());
                return new FicheIndexationHtmlProducer(parameters, fichePointeur, formEntryProvider);
            }
            case "fiche-creation": {
                Corpus corpus = requestHandler.getCorpus();
                EditionHtmlProducerFactory.checkFicheCreate(parameters, corpus);
                String prefill = requestHandler.getTrimedParameter("prefill");
                boolean isDuplicate = prefill.equals("duplicate");
                if (corpus.getMasterSubset() != null) {
                    if (isDuplicate) {
                        throw BdfErrors.error("_ error.unsupported.satellitecorpus", corpus.getSubsetName());
                    }
                    return new SatelliteFicheCreationHtmlProducer(parameters, corpus);
                }
                FichePointeur fichePointeur = PointeurFactory.newFichePointeur(corpus, true);
                if (isDuplicate) {
                    FicheMeta ficheMeta = requestHandler.getFicheMeta();
                    fichePointeur.setCurrentSubsetItem(ficheMeta);
                    fichePointeur = EditionHtmlProducerFactory.filterDuplicateFichePointeur(corpus, fichePointeur);
                }
                FormEntryProvider formEntryProvider = FormEntryProviderFactory.newInstance(parameters);
                FicheFormHtmlProducer ficheFormHtmlProducer = FicheFormHtmlProducer.newCreationInstance(parameters, fichePointeur, formEntryProvider);
                EditionHtmlProducerFactory.checkOptions(ficheFormHtmlProducer, requestHandler);
                return ficheFormHtmlProducer;
            }
            case "fiche-change": {
                Corpus corpus = requestHandler.getCorpus();
                FichePointeur fichePointeur = PointeurFactory.newFichePointeur(corpus, true);
                int id = -1;
                FicheMeta ficheMeta = (FicheMeta)parameters.getResultObject("obj.fichemeta");
                if (ficheMeta == null) {
                    id = requestHandler.getMandatoryId();
                    ficheMeta = corpus.getFicheMetaById(id);
                }
                if (ficheMeta != null) {
                    parameters.checkWrite(ficheMeta);
                    fichePointeur.setCurrentSubsetItem(ficheMeta);
                    FormEntryProvider formEntryProvider = FormEntryProviderFactory.newInstance(parameters);
                    FicheFormHtmlProducer ficheFormHtmlProducer = FicheFormHtmlProducer.newChangeInstance(parameters, fichePointeur, formEntryProvider);
                    EditionHtmlProducerFactory.checkOptions(ficheFormHtmlProducer, requestHandler);
                    return ficheFormHtmlProducer;
                }
                EditionHtmlProducerFactory.checkFicheCreate(parameters, corpus);
                SubsetItem masterSubsetItem = BdfInstructionUtils.checkMasterSubsetItem(corpus, id, parameters.getBdfUser());
                boolean force = requestHandler.isTrue("force");
                if (!force) {
                    return new CreationConfirmHtmlProducer(parameters, corpus, id, masterSubsetItem);
                }
                FormEntryProvider formEntryProvider = FormEntryProviderFactory.newInstance(FicheFormUtils.initFicheFormParametersBuilder(parameters).setMasterSubsetItem(masterSubsetItem).toFicheFormParameters());
                FicheFormHtmlProducer ficheFormHtmlProducer = masterSubsetItem != null ? FicheFormHtmlProducer.newCreationInstance((BdfParameters)parameters, fichePointeur, masterSubsetItem, formEntryProvider) : FicheFormHtmlProducer.newCreationInstance((BdfParameters)parameters, fichePointeur, id, formEntryProvider);
                EditionHtmlProducerFactory.checkOptions(ficheFormHtmlProducer, requestHandler);
                return ficheFormHtmlProducer;
            }
            case "sectionpreview": {
                Corpus corpus = requestHandler.getCorpus();
                return new SectionPreviewHtmlProducer(parameters, corpus);
            }
        }
        return null;
    }

    private static void checkOptions(FicheFormHtmlProducer ficheFormHtmlProducer, OutputRequestHandler requestHandler) throws ErrorMessageException {
        String resultPageOptions;
        String resultPage = requestHandler.getTrimedParameter("page-result");
        if (!resultPage.isEmpty()) {
            ficheFormHtmlProducer.setFicheResultPage(resultPage);
        }
        if (!(resultPageOptions = requestHandler.getTrimedParameter("page-result-options")).isEmpty()) {
            ficheFormHtmlProducer.setResultPageOptions(resultPageOptions);
        }
        ficheFormHtmlProducer.setGotoAtStart(requestHandler.getTrimedParameter("goto"));
    }

    private static void checkFicheCreate(BdfParameters bdfParameters, Corpus corpus) throws PermissionException {
        PermissionCheck.checkFicheCreate(bdfParameters.getPermissionSummary(), corpus);
    }

    private static FichePointeur filterDuplicateFichePointeur(Corpus corpus, FichePointeur originalFichePointeur) {
        Attribute excludeAttribute = corpus.getCorpusMetadata().getAttributes().getAttribute(CommandSpace.DUPLICATION_EXCLUDE_KEY);
        if (excludeAttribute != null) {
            DuplicationFilter duplicationFilter = DuplicationFilterParser.parseExclude(excludeAttribute);
            return DuplicationUtils.getFilteredFichePointeur(originalFichePointeur, duplicationFilter);
        }
        return originalFichePointeur;
    }
}

