/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.htmlproducers.edition.EditionHtmlUtils;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.annotation.Nullable;

public class CreationConfirmHtmlProducer
extends BdfServerHtmlProducer {
    private static final Button STANDARD_BUTTON = Button.submit("action-FicheCreate", "_ link.edition.fichecreation");
    private static final Button SATELLITE_BUTTON = Button.submit("action-FicheCreate", "_ label.edition.satellite_creation");
    private final Corpus corpus;
    private final int ficheId;
    private final PermissionSummary permissionSummary;
    private final SubsetItem masterSubsetItem;
    private final String corpusTitle;

    public CreationConfirmHtmlProducer(BdfParameters bdfParameters, Corpus corpus, int ficheId, @Nullable SubsetItem masterSubsetItem) {
        super(bdfParameters);
        this.corpus = corpus;
        this.ficheId = ficheId;
        this.masterSubsetItem = masterSubsetItem;
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.corpusTitle = FichothequeUtils.getTitle(corpus, this.workingLang);
    }

    @Override
    public void printHtml() {
        this.start();
        this.__(PageUnit.SIMPLE, () -> {
            this.printUnknownMessage();
            this.printCreationMessage();
        });
        this.end();
    }

    private boolean printUnknownMessage() {
        this.P().SPAN("global-ErrorMessage").__localize("_ error.unknown.fiche", this.corpusTitle, this.ficheId)._SPAN()._P();
        return true;
    }

    private boolean printCreationMessage() {
        if (!this.permissionSummary.canCreate(this.corpus)) {
            return false;
        }
        if (this.masterSubsetItem != null) {
            return this.printSatelliteCreationMessage();
        }
        return this.printStandardCreationMessage();
    }

    private boolean printStandardCreationMessage() {
        this.P().__localize("_ label.edition.withid", this.ficheId)._P().__(this.printForm(STANDARD_BUTTON));
        return true;
    }

    private boolean printSatelliteCreationMessage() {
        Subset masterSubset = this.masterSubsetItem.getSubset();
        short masterCategory = masterSubset.getSubsetKey().getCategory();
        this.P().__localize(EditionHtmlUtils.getSatelliteInfoMessageKey(masterCategory), this.corpusTitle, FichothequeUtils.getTitle(masterSubset, this.workingLang))._P().P().__localize(EditionHtmlUtils.getMasterSubsetItemMessageKey(masterCategory)).__colon()._P().UL().LI().__(this.printTitle(this.masterSubsetItem))._LI()._UL().__(this.printForm(SATELLITE_BUTTON));
        return true;
    }

    private boolean printForm(Button submitButton) {
        this.FORM_get("edition").INPUT_hidden(ParameterMap.init().subset(this.corpus).page("fiche-change").param("force", "1").param("id", String.valueOf(this.ficheId))).__(Button.COMMAND, submitButton)._FORM();
        return true;
    }

    private boolean printTitle(SubsetItem subsetItem) {
        if (subsetItem instanceof FicheMeta) {
            this.__escape(CorpusMetadataUtils.getFicheTitle((FicheMeta)subsetItem, this.workingLang, this.formatLocale));
            return true;
        }
        if (subsetItem instanceof Motcle) {
            this.__(BdfHtmlUtils.printMotcleTitle(this, (Motcle)subsetItem, this.workingLang));
            return true;
        }
        return false;
    }
}

