/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.configuration;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.MetadataPhrases;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.apps.AppConf;
import fr.exemole.bdfserver.tools.apps.AppConfUtils;
import fr.exemole.bdfserver.tools.ui.MetadataPhraseDefBuilder;
import fr.exemole.bdfserver.tools.ui.MetadataPhraseDefCatalog;
import java.util.SortedMap;
import net.fichotheque.metadata.FichothequeMetadata;
import net.mapeadores.util.html.CommandBox;

public class PhrasesFormHtmlProducer
extends BdfServerHtmlProducer {
    public PhrasesFormHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
    }

    @Override
    public void printHtml() {
        FichothequeMetadata fichothequeMetadata = this.bdfServer.getFichotheque().getFichothequeMetadata();
        MetadataPhrases metadataPhrases = MetadataPhrases.init(fichothequeMetadata, this.bdfServer.getLangConfiguration().getWorkingLangs(), "_ label.configuration.title").addDef(MetadataPhraseDefCatalog.LONG_PHRASEDEF).populateFromAttributes(null).addExtensionPhraseDefList(this.bdfServer);
        this.initAppPhrases(metadataPhrases);
        this.start();
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("configuration").family("CNF").veil(true).name("FichothequePhrases").lockey("_ CNF-04").page("config-phrases").actionCssClass("action-Labels").submitLocKey("_ submit.configuration.fichothequephrases");
        this.__start(commandBox).__(metadataPhrases).__end(commandBox);
        this.end();
    }

    private void initAppPhrases(MetadataPhrases metadataPhrases) {
        SortedMap<String, AppConf> appConfMap = AppConfUtils.getAppConfList(this.bdfServer.getResourceStorages());
        for (AppConf appConf : appConfMap.values()) {
            if (!appConf.getBoolean("active")) continue;
            this.initAppPhrase(metadataPhrases, appConf.getString("core_titlephrasename"));
            this.initAppPhrase(metadataPhrases, appConf.getString("login_titlephrasename"));
        }
    }

    private void initAppPhrase(MetadataPhrases metadataPhrases, String name) {
        if (name != null && !metadataPhrases.containsPhrase(name)) {
            metadataPhrases.addDef(MetadataPhraseDefBuilder.init(name).toMetadataPhraseDef());
        }
    }
}

