/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.configuration;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.configuration.ConfigurationAdvancedCommandsHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.configuration.CoreFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.configuration.EtcConfigHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.configuration.ExtensionsFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.configuration.GroupFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.configuration.LogosFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.configuration.PhrasesFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.configuration.SubsetTreeFormHtmlProducer;
import net.mapeadores.util.logging.ErrorMessageException;

public final class ConfigurationHtmlProducerFactory {
    private ConfigurationHtmlProducerFactory() {
    }

    public static BdfServerHtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page = parameters.getOutput();
        parameters.checkFichothequeAdmin();
        switch (page) {
            case "config-core": {
                return new CoreFormHtmlProducer(parameters);
            }
            case "config-phrases": {
                return new PhrasesFormHtmlProducer(parameters);
            }
            case "config-logos": {
                return new LogosFormHtmlProducer(parameters);
            }
            case "config-subsettree": {
                return new SubsetTreeFormHtmlProducer(parameters);
            }
            case "config-etc": {
                return new EtcConfigHtmlProducer(parameters);
            }
            case "config-extensions": {
                return new ExtensionsFormHtmlProducer(parameters);
            }
            case "config-advancedcommands": {
                return new ConfigurationAdvancedCommandsHtmlProducer(parameters);
            }
            case "config-groups": {
                return new GroupFormHtmlProducer(parameters);
            }
        }
        return null;
    }
}

