/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.album;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.album.AlbumHtmlUtils;
import fr.exemole.bdfserver.tools.BH;
import java.util.List;
import net.fichotheque.SubsetItem;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.permission.PermissionEntry;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.permission.ListFilterEngine;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;

public class AlbumHtmlProducer
extends BdfServerHtmlProducer {
    private final PermissionSummary permissionSummary;
    private final Album album;
    private final boolean isSubsetAdmin;
    private final Button linkButton = Button.link();

    public AlbumHtmlProducer(BdfParameters bdfParameters, Album album) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.album = album;
        this.isSubsetAdmin = this.permissionSummary.isSubsetAdmin(album.getSubsetKey());
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addThemeCss("album.css");
        this.setBodyCssClass("global-body-ListFrame");
        this.addStyle(AlbumHtmlUtils.getThumbnailSize(album.getAlbumMetadata()));
    }

    @Override
    public void printHtml() {
        int count;
        List<PermissionEntry> permissionEntryList = null;
        List<SubsetItem> illustrationList = this.album.getSubsetItemList();
        if (!illustrationList.isEmpty()) {
            permissionEntryList = ListFilterEngine.filter(this.album, illustrationList, this.permissionSummary);
            count = permissionEntryList.size();
        } else {
            count = 0;
        }
        this.start(FichothequeUtils.getTitle(this.album, this.workingLang), true);
        this.__(BdfHtmlUtils.startSubsetUnit(this, this.bdfParameters, this.album, "album")).__(this.printCommands()).__(PageUnit.END);
        if (count > 0) {
            this.__(PageUnit.start().sectionCss("unit-Unit album-IllustrationListUnit").title(() -> this.__localize("_ title.album.illustrations").__space().__(BdfHtmlUtils.printItemCount(this, this.bdfUser, count)))).UL("subsetitem-List").__(this.printIllustrationList(permissionEntryList))._UL().__(PageUnit.END);
        }
        this.end();
    }

    private boolean printCommands() {
        if (!this.isSubsetAdmin) {
            return false;
        }
        this.DETAILS(HA.id("details_commands").open(true).classes("tools-Details").populate(Deploy.DETAILS)).SUMMARY().__localize("_ title.global.commands")._SUMMARY().DIV("tools-List").__(this.link("action-Metadata", "album-metadataform", "_ link.album.albummetadataform")).__(this.link("action-Advanced", "album-advancedcommands", "_ link.album.albumadvancedcommands")).__(this.link("action-Refresh", "album", "_ link.global.reload"))._DIV()._DETAILS();
        return true;
    }

    private Button link(String action, String page, String messageKey) {
        String href = BH.domain("album").subset(this.album).page(page).toString();
        String target = page.equals("album") ? null : "Edition";
        return this.linkButton.href(href).action(action).textL10nObject(messageKey).target(target);
    }

    private boolean printIllustrationList(List<PermissionEntry> permissionEntryList) {
        for (PermissionEntry permissionEntry : permissionEntryList) {
            this.LI().__(this.printIllustration((Illustration)permissionEntry.getSubsetItem(), permissionEntry.isEditable()))._LI();
        }
        return true;
    }

    private boolean printIllustration(Illustration illustration, boolean editable) {
        String fileName = illustration.getFileName();
        this.DIV("album-Thumbnail").IMG(HA.src("illustrations/_mini/" + fileName))._DIV().DIV("album-Text").DIV("subsetitem-Title").P().A(HA.href("illustrations/" + fileName).target("Edition")).__escape(fileName)._A()._P().__(this.printIllustrationEdit(editable, illustration))._DIV().__(this.printIllustrationInfo(illustration))._DIV();
        return true;
    }

    private boolean printIllustrationEdit(boolean editable, Illustration illustration) {
        if (!editable) {
            return false;
        }
        this.A(HA.href(BH.domain("album").subsetItem(illustration).page("illustration-adminform")).target("Edition").classes("button-Circle action-IllustrationEdit")).__(Button.ICON)._A();
        return true;
    }

    private boolean printIllustrationInfo(Illustration illustration) {
        this.DIV("subsetitem-Infos").__escape(String.valueOf(illustration.getOriginalWidth())).__escape("\u00d7").__escape(String.valueOf(illustration.getOriginalHeight()))._DIV();
        return true;
    }
}

