/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers.attributes;

import fr.exemole.bdfserver.api.users.BdfUser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.html.HtmlAttributes;

public class Appelant
implements Consumer<HtmlAttributes> {
    private final String type;
    private final short category;
    private String sphere;
    private String wanted;
    private String anchor;
    private String fieldtype;
    private int limit;
    private List<String> subsetNameList;

    private Appelant(String type, short category) {
        this.type = type;
        this.category = category;
    }

    public static Appelant user() {
        return new Appelant("user", 3);
    }

    public static Appelant motcle() {
        return new Appelant("motcle", 2);
    }

    public static Appelant field() {
        return new Appelant("field", 1);
    }

    public static Appelant fiche() {
        return new Appelant("fiche", 1);
    }

    public Appelant anchor(String anchor) {
        this.anchor = anchor;
        return this;
    }

    public Appelant fieldtype(String fieldtype) {
        this.fieldtype = fieldtype;
        return this;
    }

    public Appelant fieldtype_date() {
        return this.fieldtype("date");
    }

    public Appelant limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Appelant sphere(String sphere) {
        this.sphere = sphere;
        return this;
    }

    public Appelant sphere(BdfUser bdfUser) {
        return this.sphere(bdfUser.getRedacteur().getSubsetName());
    }

    public Appelant subsets(SubsetKey ... subsetKeys) {
        if (subsetKeys == null) {
            return this;
        }
        if (this.subsetNameList == null) {
            this.subsetNameList = new ArrayList<String>();
        }
        for (SubsetKey item : subsetKeys) {
            if (item == null || item.getCategory() != this.category) continue;
            this.subsetNameList.add(item.getSubsetName());
        }
        return this;
    }

    public Appelant subsets(String ... subsetNames) {
        if (subsetNames == null) {
            return this;
        }
        if (this.subsetNameList == null) {
            this.subsetNameList = new ArrayList<String>();
        }
        for (String item : subsetNames) {
            if (item == null) continue;
            this.subsetNameList.add(item);
        }
        return this;
    }

    public Appelant wanted(String wanted) {
        this.wanted = wanted;
        return this;
    }

    public Appelant wanted_code_id() {
        return this.wanted("code-id");
    }

    @Override
    public void accept(HtmlAttributes htmlAttributes) {
        String subsets = null;
        if (this.subsetNameList != null) {
            StringBuilder buf = new StringBuilder();
            for (String subsetName : this.subsetNameList) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(subsetName);
            }
            subsets = buf.toString();
        }
        htmlAttributes.attr("data-appelant-role", "input").attr("data-appelant-type", this.type).attr("data-appelant-anchor", this.anchor).attr(this.limit > 0, "data-appelant-limit", String.valueOf(this.limit)).attr("data-appelant-subsets", subsets).attr("data-appelant-sphere", this.sphere).attr("data-appelant-wanted", this.wanted).attr("data-appelant-fieldtype", this.fieldtype);
    }
}

