/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdUtils;
import net.mapeadores.opendocument.io.OdZip;
import net.mapeadores.opendocument.io.OdZipEngine;
import net.mapeadores.opendocument.io.SheetNameChecker;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.opendocument.io.odtable.OdsOptions;
import net.mapeadores.opendocument.io.odtable.OdsXMLPart;
import net.mapeadores.opendocument.io.odtable.StyleManager;
import net.mapeadores.opendocument.io.odtable.StyleManagerBuilder;
import net.mapeadores.opendocument.io.odtable.TableSettings;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.io.TempStorageAppendable;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class SphereOdsProducer
implements StreamProducer {
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;
    private final Sphere sphere;
    private final boolean all;
    private final SheetNameChecker sheetNameChecker;
    private final MessageLocalisation messageLocalisation;
    private final PermissionManager permissionManager;

    public SphereOdsProducer(BdfServer bdfServer, BdfUser bdfUser, Sphere sphere) {
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
        this.sphere = sphere;
        this.all = sphere == null;
        this.messageLocalisation = bdfServer.getL10nManager().getMessageLocalisation(bdfUser);
        this.sheetNameChecker = new SheetNameChecker();
        this.permissionManager = bdfServer.getPermissionManager();
    }

    @Override
    public String getMimeType() {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        OdsOptions odsOptions = BdfServerUtils.buildOdsOptions(this.bdfServer, "bdf://this/css/ods/sphere.css");
        Tables tables = new Tables();
        OdZipEngine.run(outputStream, OdZip.spreadSheet().stylesOdSource(OdUtils.toStyleOdSource(odsOptions.elementMaps(), true)).contentOdSource(new ContentOdSource(odsOptions, tables)).settingsOdSource(OdUtils.getSettingsOdSource(tables.getSettings())));
    }

    private static String toAllStringKey(Redacteur redacteur) {
        return redacteur.getSubsetName() + "_" + redacteur.getLogin();
    }

    private class Tables {
        private final String mainTableName;
        private final List<CategoryInfo> categoryInfoList = new ArrayList<CategoryInfo>();
        private final TreeMap<String, Redacteur> activeMap = new TreeMap();
        private final TreeMap<String, Redacteur> readonlyMap = new TreeMap();
        private final TreeMap<String, Redacteur> inactiveMap = new TreeMap();

        private Tables() {
            String tableName;
            if (SphereOdsProducer.this.all) {
                tableName = SphereOdsProducer.this.messageLocalisation.toString("_ label.selection.users");
                if (tableName == null) {
                    tableName = "_all";
                }
            } else {
                tableName = FichothequeUtils.getTitleWithKey(SphereOdsProducer.this.sphere, SphereOdsProducer.this.bdfUser.getWorkingLang());
            }
            this.mainTableName = SphereOdsProducer.this.sheetNameChecker.checkName(tableName);
            this.initCategory((short)1);
            this.initCategory((short)2);
            this.initCategory((short)3);
            this.initCategory((short)5);
            this.initCategory((short)4);
            this.init();
        }

        private void init() {
            if (SphereOdsProducer.this.all) {
                for (Sphere sphere : SphereOdsProducer.this.bdfServer.getFichotheque().getSphereList()) {
                    for (Redacteur redacteur : sphere.getRedacteurList()) {
                        TreeMap<String, Redacteur> map = this.getMap(redacteur);
                        map.put(SphereOdsProducer.toAllStringKey(redacteur), redacteur);
                    }
                }
            } else {
                for (Redacteur redacteur : SphereOdsProducer.this.sphere.getRedacteurList()) {
                    TreeMap<String, Redacteur> map = this.getMap(redacteur);
                    map.put(redacteur.getLogin(), redacteur);
                }
            }
        }

        public String getMainTableName() {
            return this.mainTableName;
        }

        public Collection<TableSettings> getSettings() {
            int fixedColumns = SphereOdsProducer.this.all ? 2 : 1;
            ArrayList<TableSettings> list = new ArrayList<TableSettings>();
            list.add(TableSettings.init(this.mainTableName).fixedRows(1).fixedColumns(fixedColumns));
            for (CategoryInfo categoryInfo : this.categoryInfoList) {
                list.add(TableSettings.init(categoryInfo.tableName).fixedRows(1).fixedColumns(fixedColumns));
            }
            return list;
        }

        private void initCategory(short subsetCategory) {
            CategoryInfo categoryInfo = new CategoryInfo(subsetCategory);
            if (!categoryInfo.isEmpty()) {
                this.categoryInfoList.add(categoryInfo);
            }
        }

        private void addTableDefs(StyleManagerBuilder styleManagerBuilder) {
            int firstCols = SphereOdsProducer.this.all ? 4 : 3;
            OdTableDef mainTableDef = OdTableDefBuilder.init(this.mainTableName).addStandards(firstCols).addStandard("Email").addStandard("Status").addStandard("Roles").toOdTableDef();
            styleManagerBuilder.addTableDef(mainTableDef);
            this.addRoleTableDef(styleManagerBuilder);
        }

        private void addRoleTableDef(StyleManagerBuilder styleManagerBuilder) {
            int firstCols = SphereOdsProducer.this.all ? 2 : 1;
            for (CategoryInfo categoryInfo : this.categoryInfoList) {
                styleManagerBuilder.addTableDef(OdTableDefBuilder.init(categoryInfo.tableName).addStandards(firstCols).addStandards(categoryInfo.subsetArray.length, "Subset").toOdTableDef());
            }
        }

        private void addMain(XMLWriter xmlWriter, StyleManager styleManager) throws IOException {
            SphereXMLPart sphereXMLPart = new SphereXMLPart(xmlWriter, styleManager);
            sphereXMLPart.addTable(this.mainTableName, this.activeMap, this.readonlyMap, this.inactiveMap);
        }

        private void addRoles(XMLWriter xmlWriter, StyleManager styleManager) throws IOException {
            ArrayList<PermissionEntry> permissionList = new ArrayList<PermissionEntry>();
            for (Redacteur redacteur : this.activeMap.values()) {
                permissionList.add(new PermissionEntry(redacteur, PermissionSummaryBuilder.build(SphereOdsProducer.this.permissionManager, redacteur)));
            }
            RolesXMLPart xmlPart = new RolesXMLPart(xmlWriter, styleManager);
            for (CategoryInfo categoryInfo : this.categoryInfoList) {
                xmlPart.addTable(categoryInfo, permissionList);
            }
        }

        private TreeMap<String, Redacteur> getMap(Redacteur redacteur) {
            switch (redacteur.getStatus()) {
                case "inactive": {
                    return this.inactiveMap;
                }
                case "readonly": {
                    return this.readonlyMap;
                }
            }
            return this.activeMap;
        }
    }

    private class ContentOdSource
    implements OdSource {
        private final OdsOptions odsOptions;
        private final Tables tables;

        private ContentOdSource(OdsOptions odsOptions, Tables tables) {
            this.odsOptions = odsOptions;
            this.tables = tables;
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            StyleManager styleManager = this.initStyleManager();
            TempStorageAppendable bodyBuffer = new TempStorageAppendable();
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(bodyBuffer, 3);
            this.tables.addMain(xmlWriter, styleManager);
            this.tables.addRoles(xmlWriter, styleManager);
            OdUtils.writeSpreadSheetDocumentContent(outputStream, bodyBuffer, styleManager);
        }

        private StyleManager initStyleManager() {
            StyleManagerBuilder styleManagerBuilder = StyleManagerBuilder.init().setElementMaps(this.odsOptions.elementMaps());
            this.tables.addTableDefs(styleManagerBuilder);
            return styleManagerBuilder.toStyleManager();
        }
    }

    private static class PermissionEntry {
        private final Redacteur redacteur;
        private final PermissionSummary permissionSummary;

        private PermissionEntry(Redacteur redacteur, PermissionSummary permissionSummary) {
            this.redacteur = redacteur;
            this.permissionSummary = permissionSummary;
        }

        public Redacteur getRedacteur() {
            return this.redacteur;
        }

        public PermissionSummary getPermissionSummary() {
            return this.permissionSummary;
        }
    }

    private class CategoryInfo {
        private final short category;
        private final String tableName;
        private final Subset[] subsetArray;

        private CategoryInfo(short category) {
            this.category = category;
            this.subsetArray = FichothequeUtils.toSubsetArray(SphereOdsProducer.this.bdfServer.getFichotheque(), category);
            String locKey = BdfHtmlUtils.getSubsetCollectionLocKey(category);
            String title = SphereOdsProducer.this.messageLocalisation.toString(locKey);
            if (title == null) {
                title = SubsetKey.categoryToString(category);
            }
            this.tableName = SphereOdsProducer.this.sheetNameChecker.checkName(title);
        }

        public boolean isEmpty() {
            return this.subsetArray.length == 0;
        }
    }

    private class RolesXMLPart
    extends OdsXMLPart {
        private RolesXMLPart(XMLWriter xmlWriter, StyleManager styleManager) {
            super(xmlWriter, styleManager);
        }

        private void addTable(CategoryInfo categoryInfo, List<PermissionEntry> entryList) throws IOException {
            Subset[] array = categoryInfo.subsetArray;
            this.tableStart(categoryInfo.tableName);
            this.addFirstRow(array);
            for (PermissionEntry permissionEntry : entryList) {
                PermissionSummary permissionSummary;
                this.rowStart();
                this.stringCell(permissionEntry.getRedacteur().getLogin(), "Login");
                if (SphereOdsProducer.this.all) {
                    this.stringCell(permissionEntry.getRedacteur().getSubsetName());
                }
                if ((permissionSummary = permissionEntry.getPermissionSummary()).isFichothequeAdmin()) {
                    for (Subset subset : array) {
                        this.stringCell("A", "Admin");
                    }
                } else {
                    for (Subset subset : array) {
                        this.addPermission(permissionSummary, subset.getSubsetKey());
                    }
                }
                this.rowEnd();
            }
            this.tableEnd();
        }

        private void addFirstRow(Subset[] array) throws IOException {
            Lang lang = SphereOdsProducer.this.bdfUser.getWorkingLang();
            this.rowStart();
            this.stringCell(SphereOdsProducer.this.messageLocalisation.toString("_ label.session.login"), "ColumnHeader");
            if (SphereOdsProducer.this.all) {
                this.stringCell(SphereOdsProducer.this.messageLocalisation.toString("_ label.session.sphere"), "ColumnHeader");
            }
            for (Subset subset : array) {
                this.stringCell(FichothequeUtils.getTitle(subset, lang));
            }
            this.rowEnd();
        }

        private void addPermission(PermissionSummary permissionSummary, SubsetKey subsetKey) throws IOException {
            if (permissionSummary.isSubsetAdmin(subsetKey)) {
                this.stringCell("A", "Admin");
                return;
            }
            int readLevel = permissionSummary.getReadLevel(subsetKey);
            if (readLevel == 0) {
                this.stringCell("N", "None");
                return;
            }
            if (!subsetKey.isCorpusSubset()) {
                this.stringCell("S", "Standard");
                return;
            }
            int writeLevel = permissionSummary.getWriteLevel(subsetKey);
            boolean canCreate = permissionSummary.canCreate(subsetKey);
            if (canCreate && readLevel == 4 && writeLevel == 1) {
                this.stringCell("S", "Standard");
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("R=");
            buf.append(RoleUtils.permissionSummaryLevelToString(readLevel));
            if (writeLevel != 0) {
                buf.append(" W=");
                buf.append(RoleUtils.permissionSummaryLevelToString(writeLevel));
            }
            if (canCreate) {
                buf.append(" C");
            }
            this.stringCell(buf.toString(), "Custom");
        }
    }

    private class SphereXMLPart
    extends OdsXMLPart {
        private SphereXMLPart(XMLWriter xmlWriter, StyleManager styleManager) {
            super(xmlWriter, styleManager);
        }

        public void addTable(String name, TreeMap<String, Redacteur> activeMap, TreeMap<String, Redacteur> readonlyMap, TreeMap<String, Redacteur> inactiveMap) throws IOException {
            this.tableStart(name);
            this.addFirstRow();
            this.addMap(activeMap);
            this.addMap(readonlyMap);
            this.addMap(inactiveMap);
            this.tableEnd();
        }

        private void addMap(Map<String, Redacteur> map) throws IOException {
            for (Map.Entry<String, Redacteur> mapEntry : map.entrySet()) {
                Redacteur redacteur = mapEntry.getValue();
                this.addRedacteur(redacteur);
            }
        }

        private void addRedacteur(Redacteur redacteur) throws IOException {
            this.rowStart();
            this.stringCell(redacteur.getLogin(), "Login");
            if (SphereOdsProducer.this.all) {
                this.stringCell(redacteur.getSubsetName());
            }
            PersonCore personCore = redacteur.getPersonCore();
            this.stringCell(personCore.getSurname());
            this.stringCell(personCore.getForename());
            EmailCore emailCore = redacteur.getEmailCore();
            if (emailCore != null) {
                this.stringCell(emailCore.getAddrSpec());
            } else {
                this.emptyCell();
            }
            this.addStatus(redacteur);
            if (!redacteur.isInactive()) {
                StringBuilder buf = new StringBuilder();
                for (Role role : SphereOdsProducer.this.permissionManager.getRoleList(redacteur)) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(role.getName());
                }
                this.stringCell(buf.toString());
            }
            this.rowEnd();
        }

        private void addFirstRow() throws IOException {
            this.rowStart();
            this.stringCell(SphereOdsProducer.this.messageLocalisation.toString("_ label.session.login"), "ColumnHeader");
            if (SphereOdsProducer.this.all) {
                this.stringCell(SphereOdsProducer.this.messageLocalisation.toString("_ label.session.sphere"), "ColumnHeader");
            }
            this.stringCell(SphereOdsProducer.this.messageLocalisation.toString("_ label.sphere.surname"), "ColumnHeader");
            this.stringCell(SphereOdsProducer.this.messageLocalisation.toString("_ label.sphere.forename"), "ColumnHeader");
            this.stringCell(SphereOdsProducer.this.messageLocalisation.toString("_ label.sphere.email"), "ColumnHeader");
            this.stringCell(SphereOdsProducer.this.messageLocalisation.toString("_ label.sphere.userstatus"), "ColumnHeader");
            this.stringCell(SphereOdsProducer.this.messageLocalisation.toString("_ title.sphere.rolelist"), "ColumnHeader");
            this.rowEnd();
        }

        private void addStatus(Redacteur redacteur) throws IOException {
            if (SphereOdsProducer.this.permissionManager.isAdmin(redacteur)) {
                this.stringCell("A", "Admin");
            } else {
                switch (redacteur.getStatus()) {
                    case "inactive": {
                        this.stringCell("D", "Inactive");
                        break;
                    }
                    case "readonly": {
                        this.stringCell("C", "Readonly");
                        break;
                    }
                    default: {
                        this.stringCell("B", "User");
                    }
                }
            }
        }
    }
}

